/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.be.Position;
import org.catacomb.graph.gui.Geom;
import org.catacomb.graph.gui.Pickable;
import org.catacomb.report.E;
import org.catacomb.util.MathUtil;

public final class PickableRegion
implements Pickable {
    double[] xb;
    double[] yb;
    String label;
    String tag;
    double xref;
    double yref;
    Object oref;
    int icache;

    public PickableRegion(double[][] axay, Object obj) {
        this(axay[0], axay[1], obj);
    }

    public PickableRegion(double[] axb, double[] ayb, Object obj) {
        if (axb == null || axb.length < 2) {
            E.error("need at least 2 elts but got " + axb);
        }
        if (axb.length < 3) {
            this.xb = this.mmxx(axb);
            this.yb = this.mxxm(ayb);
        } else {
            this.xb = axb;
            this.yb = ayb;
        }
        this.oref = obj;
        this.xref = this.xb[0];
        this.yref = this.yb[0];
    }

    public double[] getXPts() {
        return this.xb;
    }

    public double[] getYPts() {
        return this.yb;
    }

    public boolean contains(double xq, double yq) {
        return Geom.pointIsInside(this.xb, this.yb, xq, yq);
    }

    public void setReferencePoint(Position p) {
        this.setReferencePoint(p.getX(), p.getY());
    }

    public Position getReferencePoint() {
        return new Position(this.xref, this.yref);
    }

    public void setPoints(double[][] axy) {
        this.xb = axy[0];
        this.yb = axy[1];
    }

    public void setPoints(double[] ax, double[] ay) {
        this.xb = ax;
        this.yb = ay;
    }

    public void setReferencePoint(double xr, double yr) {
        this.xref = xr;
        this.yref = yr;
    }

    public void moveTo(Position pos) {
        this.moveTo(pos.getX(), pos.getY());
    }

    public void moveTo(double cx, double cy) {
        double dx = cx - this.xref;
        double dy = cy - this.yref;
        int i = 0;
        while (i < this.xb.length) {
            int n = i;
            this.xb[n] = this.xb[n] + dx;
            int n2 = i++;
            this.yb[n2] = this.yb[n2] + dy;
        }
        this.xref = cx;
        this.yref = cy;
    }

    public void scaleTo(double z) {
        this.scaleTo(z, z);
    }

    public void scaleTo(double xsz, double ysz) {
        MathUtil.scaleRangeTo(2.0 * xsz, this.xb);
        MathUtil.scaleRangeTo(2.0 * ysz, this.yb);
    }

    public double getXReference() {
        return this.xref;
    }

    public double getYReference() {
        return this.yref;
    }

    @Override
    public Object getRef() {
        return this.oref;
    }

    @Override
    public void setCache(int ic) {
        this.icache = ic;
    }

    @Override
    public int getCache() {
        return this.icache;
    }

    public double[] mxxm(double[] v) {
        double min = MathUtil.min(v);
        double max = MathUtil.max(v);
        double[] ret = new double[]{min, max, max, min};
        return ret;
    }

    public double[] mmxx(double[] v) {
        double min = MathUtil.min(v);
        double max = MathUtil.max(v);
        double[] ret = new double[]{min, min, max, max};
        return ret;
    }

    public void setRegionTag(String s) {
        this.tag = s;
    }

    public String getRegionTag() {
        return this.tag;
    }
}

