/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;

final class RollHandler
extends MouseHandler {
    private int xc;
    private int yc;
    private double rcx = Double.NaN;
    private double rcy = Double.NaN;
    private double rcz = Double.NaN;
    static final int NORMAL = 0;
    static final int SIMPLE = 1;
    int actionMode = 0;
    boolean aaCache;

    @Override
    public void init(Mouse m) {
        this.xc = m.getX();
        this.yc = m.getY();
        if (this.actionMode == 1) {
            if (m.leftButton()) {
                this.setClaimIn();
            } else {
                this.setClaimOut();
            }
        } else {
            m.rightButton();
        }
    }

    @Override
    public void advance(Mouse m) {
        int dy;
        int dx;
        if (this.actionMode == 0 && m.leftButton() && (dx = m.getX() - this.xc) * dx + (dy = m.getY() - this.yc) * dy > 100) {
            this.setClaimIn();
            this.applyOnDown(m);
        }
    }

    @Override
    public void activate() {
        this.actionMode = 0;
        super.activate();
    }

    public void simpleActivate() {
        this.activate();
        this.actionMode = 1;
    }

    public void setRollCenter(double x, double y, double z) {
        this.rcx = x;
        this.rcy = y;
        this.rcz = z;
    }

    @Override
    public void applyOnDown(Mouse m) {
        if (Double.isNaN(this.rcx)) {
            m.initializeRotation(m.getX(), m.getY());
        } else {
            m.initializeRotation(this.rcx, this.rcy, this.rcz);
        }
    }

    @Override
    public void applyOnDrag(Mouse m) {
        int x = m.getX();
        int y = m.getY();
        m.dragRollRotate(x - this.xc, y - this.yc);
        this.setFullRepaint();
    }

    @Override
    public void applyOnRelease(Mouse m) {
        m.restoreAA();
    }
}

