/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.be.Position;
import org.catacomb.datalish.Box;
import org.catacomb.graph.gui.RangeListener;
import org.catacomb.graph.gui.RotationListener;
import org.catacomb.graph.gui.Size;
import org.catacomb.report.E;

public final class WorldTransform {
    private double wcx;
    private double wcy;
    private int pcx;
    private int pcy;
    private int width;
    private int height;
    private int hx;
    private int hy;
    private double dpdwx;
    private double dpdwy;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private boolean xRescalable;
    private boolean yRescalable;
    private static final int IBIG = 20000;
    private static final double SMALL = 1.0E-7;
    private final double DBIG = 1.0E9;
    private boolean recordRange;
    private double aspectRatio;
    private boolean constantAspectRatio;
    private double vxmin;
    private double vxmax;
    private double vymin;
    private double vymax;
    private boolean trialPanning = false;
    private double wcxtp;
    private double wcytp;
    private double w2cx;
    private double w2cy;
    private double w2cz;
    private double w3cx;
    private double w3cy;
    private double w3cz;
    private double m3xx = 1.0;
    private double m3yy = 1.0;
    private double m3zz = 1.0;
    private double m3xy = 0.0;
    private double m3xz = 0.0;
    private double m3yx = 0.0;
    private double m3yz = 0.0;
    private double m3zx = 0.0;
    private double m3zy = 0.0;
    private double[][] m3B;
    private double zoomCenX;
    private double zoomCenY;
    private double dpdwx0;
    private double dpdwy0;
    private double wcx0;
    private double wcy0;
    int nRangeListener;
    private RangeListener[] rangeListeners;
    private RotationListener rotationListener;
    private Size p_pixelSize;

    public WorldTransform() {
        this.setWidth(100);
        this.setHeight(100);
        this.setXRescalable(true);
        this.setYRescalable(true);
        this.setAspectRatioFree();
        this.dpdwx = 1.0;
        this.dpdwy = 1.0;
        this.wcx = 0.0;
        this.wcy = 0.0;
        this.nRangeListener = 0;
        this.rangeListeners = new RangeListener[10];
        this.p_pixelSize = new Size(0.0, 0.0);
    }

    public void setCanvasSize(int w, int h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public final void setMargins(int l, int r, int b, int t) {
        this.leftMargin = l;
        this.rightMargin = r;
        this.topMargin = t;
        this.bottomMargin = b;
    }

    public boolean isOnCanvas(double x, double y) {
        return this.intIsOnCanvas(this.powx(x), this.powy(y));
    }

    public boolean intIsOnCanvas(int x, int y) {
        return x > -10 && x < this.width + 10 && y > -10 && y < this.height + 10;
    }

    public void addRangeListener(RangeListener rl) {
        this.rangeListeners[this.nRangeListener++] = rl;
        rl.rangeChanged(3, this.getXYXYLimits());
    }

    public void setRotationListener(RotationListener rl) {
        this.rotationListener = rl;
    }

    public void fixRanges() {
        this.notifyRangeChange(3);
    }

    public void rangeChange(int axis) {
    }

    public void notifyRangeChange() {
        this.notifyRangeChange(3);
    }

    public void notifyRangeChange(int axis) {
        double[] lims = this.getXYXYLimits();
        int i = 0;
        while (i < this.nRangeListener) {
            this.rangeListeners[i].rangeChanged(axis, lims);
            ++i;
        }
    }

    public void setPixelScalingFromTop(double d) {
        this.p_setXRange(0.0, d * (double)this.getCanvasWidth());
        this.p_setYRange(-1.0 * d * (double)this.getCanvasHeight(), 0.0);
    }

    public void setAspectRatioFree() {
        this.constantAspectRatio = false;
    }

    public void setFixedAspectRatio(double f) {
        this.setAspectRatio(f);
    }

    public void setAspectRatio(double f) {
        this.aspectRatio = f;
        this.constantAspectRatio = true;
    }

    public void setXRescalable(boolean b) {
        this.xRescalable = b;
    }

    public void setYRescalable(boolean b) {
        this.yRescalable = b;
    }

    void clearRanges() {
        this.vxmin = 1.0E9;
        this.vymin = 1.0E9;
        this.vxmax = -1.0E9;
        this.vymax = -1.0E9;
    }

    void startRangeRecording() {
        this.clearRanges();
        this.recordRange = true;
    }

    void stopRangeRecording() {
        this.recordRange = false;
    }

    public void setWidth(int w) {
        this.width = w;
        this.hx = (this.width - this.leftMargin - this.rightMargin) / 2;
        if (this.hx < 2) {
            this.hx = 2;
        }
        this.pcx = this.leftMargin + this.hx;
    }

    public void setHeight(int h) {
        this.height = h;
        this.hy = (this.height - this.topMargin - this.bottomMargin) / 2;
        if (this.hy < 2) {
            this.hy = 2;
        }
        this.pcy = this.bottomMargin + this.hy;
    }

    public int getCanvasWidth() {
        return this.width;
    }

    public int getCanvasHeight() {
        return this.height;
    }

    public double getWorldCanvasWidth() {
        return (double)this.width / this.dpdwx;
    }

    public boolean isShowing(double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        return ix > 5 && iy > 5 && ix < this.width - 50 && iy < this.height - 5;
    }

    int[] intDeviceX(double[] wx) {
        int n = wx.length;
        int[] idev = new int[n];
        if (this.recordRange) {
            int i = 0;
            while (i < n) {
                idev[i] = this.qpowx(wx[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                idev[i] = this.powx(wx[i]);
                ++i;
            }
        }
        return idev;
    }

    int[] intDeviceY(double[] wy) {
        int n = wy.length;
        int[] idev = new int[n];
        if (this.recordRange) {
            int i = 0;
            while (i < n) {
                idev[i] = this.qpowy(wy[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                idev[i] = this.powy(wy[i]);
                ++i;
            }
        }
        return idev;
    }

    float[] floatDeviceX(double[] wx) {
        int n = wx.length;
        float[] fdev = new float[n];
        if (this.recordRange) {
            int i = 0;
            while (i < n) {
                fdev[i] = this.qpowx(wx[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                fdev[i] = this.powx(wx[i]);
                ++i;
            }
        }
        return fdev;
    }

    float[] floatDeviceY(double[] wy) {
        int n = wy.length;
        float[] fdev = new float[n];
        if (this.recordRange) {
            int i = 0;
            while (i < n) {
                fdev[i] = this.qpowy(wy[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                fdev[i] = this.powy(wy[i]);
                ++i;
            }
        }
        return fdev;
    }

    public Size getPixelSize() {
        this.p_pixelSize.set(1.0 / this.dpdwx, 1.0 / this.dpdwy);
        return this.p_pixelSize;
    }

    public double getPixelArea() {
        return 1.0 / this.dpdwx * 1.0 / this.dpdwy;
    }

    protected final double wopx(int x) {
        return this.wcx + (double)(x - this.pcx) / this.dpdwx;
    }

    protected final double wopy(int y) {
        return this.wcy + (double)(this.height - y - this.pcy) / this.dpdwy;
    }

    protected final int powx(double xr) {
        double f = this.dpdwx * (xr - this.wcx);
        if (f > 20000.0) {
            f = 20000.0;
        }
        if (f < -20000.0) {
            f = -20000.0;
        }
        int ii = this.pcx + (int)f;
        if (this.recordRange) {
            if (xr > this.vxmax) {
                this.vxmax = xr;
            }
            if (xr < this.vxmin) {
                this.vxmin = xr;
            }
        }
        if (ii > 0) {
            // empty if block
        }
        return ii;
    }

    protected final int powy(double yr) {
        double f = this.dpdwy * (yr - this.wcy);
        if (f > 20000.0) {
            f = 20000.0;
        }
        if (f < -20000.0) {
            f = -20000.0;
        }
        int ii = this.height - (this.pcy + (int)f);
        if (this.recordRange) {
            if (yr > this.vymax) {
                this.vymax = yr;
            }
            if (yr < this.vymin) {
                this.vymin = yr;
            }
        }
        if (ii > 0) {
            // empty if block
        }
        return ii;
    }

    private final int qpowx(double xr) {
        return (int)((double)this.pcx + this.dpdwx * (xr - this.wcx));
    }

    private final int qpowy(double yr) {
        return (int)((double)this.height - ((double)this.pcy + this.dpdwy * (yr - this.wcy)));
    }

    public final int pubPowx(double xr) {
        return this.powx(xr);
    }

    public final int pubPowy(double yr) {
        return this.powy(yr);
    }

    public final Position getWorldPosition(int x, int y) {
        return new Position(this.wopx(x), this.wopy(y));
    }

    public final double pubWopx(int x) {
        return this.wopx(x);
    }

    public final double pubWopy(int y) {
        return this.wopy(y);
    }

    public final int pubPixDx(double dxr) {
        return (int)(this.dpdwx * dxr);
    }

    public final int pubPixDy(double dyr) {
        return (int)(this.dpdwy * dyr);
    }

    public final double dPdX() {
        return this.dpdwx;
    }

    public final double dPdY() {
        return this.dpdwy;
    }

    public final double pubDyDpix() {
        return 1.0 / this.dpdwy;
    }

    public final double pubDxDpix() {
        return 1.0 / this.dpdwx;
    }

    public final double wxLeft() {
        return this.wcx - (double)this.hx / this.dpdwx;
    }

    public final double wxRight() {
        return this.wcx + (double)this.hx / this.dpdwx;
    }

    public final double wyBottom() {
        return this.wcy - (double)this.hy / this.dpdwy;
    }

    public final double wyTop() {
        return this.wcy + (double)this.hy / this.dpdwy;
    }

    private final void enforceAspectRatioY() {
        if (this.xRescalable) {
            this.dpdwx = 1.0 / this.aspectRatio * this.dpdwy;
        } else if (this.yRescalable) {
            this.dpdwy = this.aspectRatio * this.dpdwx;
        }
    }

    private final void enforceAspectRatioX() {
        if (this.yRescalable) {
            this.dpdwy = this.aspectRatio * this.dpdwx;
        } else if (this.xRescalable) {
            this.dpdwx = 1.0 / this.aspectRatio * this.dpdwy;
        }
    }

    private void zoomAbout(double f, int xc, int yc) {
        this.zoomAbout(f, f, xc, yc);
    }

    private void zoomAbout(double fx, double fy, int xc, int yc) {
        this.xZoomAbout(fx, xc);
        this.yZoomAbout(fy, yc);
        if (this.constantAspectRatio) {
            this.enforceAspectRatioY();
        }
        this.rangeChange(3);
    }

    private void xZoomAbout(double f, int xc) {
        double xWorld = this.wopx(xc);
        if (xc > this.leftMargin && this.xRescalable) {
            this.wcx = xWorld + f * (this.wcx - xWorld);
            this.dpdwx /= f;
            if (this.dpdwx > 1.0E7) {
                this.dpdwx = 1.0E7;
            }
        }
    }

    private void yZoomAbout(double f, int yc) {
        double yWorld = this.wopy(yc);
        if (yc < this.height - this.bottomMargin && this.yRescalable) {
            this.wcy = yWorld + f * (this.wcy - yWorld);
            this.dpdwy /= f;
            if (this.dpdwy > 1.0E7) {
                this.dpdwy = 1.0E7;
            }
        }
    }

    void initializeZoom(int xc, int yc) {
        this.zoomCenX = this.wopx(xc);
        this.zoomCenY = this.wopy(yc);
        this.dpdwx0 = this.dpdwx;
        this.dpdwy0 = this.dpdwy;
        this.wcx0 = this.wcx;
        this.wcy0 = this.wcy;
    }

    void dragZoom(double fxin, double fyin, int xc, int yc) {
        double fx = fxin;
        double fy = fyin;
        if (this.constantAspectRatio) {
            fx = fy;
        }
        if (xc > this.leftMargin && this.xRescalable) {
            this.wcx = this.zoomCenX + fx * (this.wcx0 - this.zoomCenX);
            this.dpdwx = this.dpdwx0 / fx;
            if (this.dpdwx > 1.0E7) {
                this.dpdwx = 1.0E7;
            }
        }
        if (yc < this.height - this.bottomMargin && this.yRescalable) {
            this.wcy = this.zoomCenY + fy * (this.wcy0 - this.zoomCenY);
            this.dpdwy = this.dpdwy0 / fy;
            if (this.dpdwy > 1.0E7) {
                this.dpdwy = 1.0E7;
            }
        }
        if (this.constantAspectRatio) {
            this.enforceAspectRatioY();
        }
    }

    public void reframe(Box b) {
        this.setXRange(b.getXmin(), b.getXmax());
        this.setYRange(b.getYmin(), b.getYmax());
        this.notifyRangeChange();
    }

    public void setXRange(double xl, double xh) {
        this.p_setXRange(xl, xh);
    }

    public void setYRange(double yl, double yh) {
        this.p_setYRange(yl, yh);
    }

    private void p_setXRange(double xlin, double xhin) {
        double xh = xhin;
        double xl = xlin;
        if (xh < xl) {
            double xt = xh;
            xh = xl;
            xl = xt;
        }
        if (this.xRescalable) {
            if (xh <= xl) {
                xh += 0.5;
                xl -= 0.5;
            }
            this.wcx = 0.5 * (xl + xh);
            if (xh <= xl + 1.0E-7) {
                xh = xl + 1.0E-7;
            }
            this.dpdwx = 2.0 * (double)this.hx / (xh - xl);
        }
        if (this.constantAspectRatio) {
            this.enforceAspectRatioX();
        }
        this.rangeChange(1);
    }

    public void ensureCovers(double xl, double yl, double xh, double yh) {
        if ((xh - xl) * (double)this.hy > (yh - yl) * (double)this.hx) {
            this.p_setYRange(yl, yh);
            this.p_setXRange(xl, xh);
        } else {
            this.p_setXRange(xl, xh);
            this.p_setYRange(yl, yh);
        }
    }

    private void p_setYRange(double ylin, double yhin) {
        double yh = yhin;
        double yl = ylin;
        if (yh < yl) {
            double yt = yh;
            yh = yl;
            yl = yt;
        }
        if (this.yRescalable) {
            if (yh <= yl) {
                yl -= 0.5;
                yh += 0.5;
            }
            this.wcy = 0.5 * (yl + yh);
            if (yh <= yl + 1.0E-7) {
                yh = yl + 1.0E-7;
            }
            this.dpdwy = 2.0 * (double)this.hy / (yh - yl);
        }
        if (this.constantAspectRatio) {
            this.enforceAspectRatioY();
        }
        this.rangeChange(2);
    }

    public final double[] getXYXYLimits() {
        double[] range = new double[]{this.wxLeft(), this.wyBottom(), this.wxRight(), this.wyTop()};
        return range;
    }

    public double[] getXRange() {
        double[] d = new double[]{this.wxLeft(), this.wxRight()};
        return d;
    }

    public double[] getYRange() {
        double[] d = new double[]{this.wyBottom(), this.wyTop()};
        return d;
    }

    public final void setXYXYLimits(double xl, double yl, double xh, double yh) {
        if (this.constantAspectRatio) {
            if ((xh - xl) / (double)(this.width - this.leftMargin - this.rightMargin) > (yh - yl) / (double)(this.height - this.topMargin - this.bottomMargin)) {
                this.p_setYRange(yl, yh);
                this.p_setXRange(xl, xh);
            } else {
                this.p_setXRange(xl, xh);
                this.p_setYRange(yl, yh);
            }
        } else {
            this.p_setXRange(xl, xh);
            this.p_setYRange(yl, yh);
        }
    }

    void applyRecordedRange() {
        double dx = 0.1 * (this.vxmax - this.vxmin);
        double dy = 0.1 * (this.vymax - this.vymin);
        double xa = this.vxmin - dx;
        double xb = this.vxmax + dx;
        double ya = this.vymin - dy;
        double yb = this.vymax + dy;
        if (this.vxmin > 1.0E8 && this.vxmax < -1.0E8) {
            this.setXYXYLimits(0.0, 0.0, 1.0, 1.0);
        } else {
            this.setXYXYLimits(xa, ya, xb, yb);
        }
    }

    void boxSelected(int x0, int y0, int x1, int y1) {
        this.p_setXRange(this.wopx(x0), this.wopx(x1));
        this.p_setYRange(this.wopy(y0), this.wopy(y1));
    }

    void zoom(double fac, int xc, int yc) {
        this.zoomAbout(fac, xc, yc);
    }

    void zoom(double xfac, double yfac, int xc, int yc) {
        this.zoomAbout(xfac, yfac, xc, yc);
    }

    void trialPan(int xfrom, int yfrom, int xto, int yto) {
        if (!this.trialPanning) {
            this.wcxtp = this.wcx;
            this.wcytp = this.wcy;
            this.trialPanning = true;
        }
        this.wcx = this.wcxtp - (this.wopx(xto) - this.wopx(xfrom));
        this.wcy = this.wcytp - (this.wopy(yto) - this.wopy(yfrom));
        this.rangeChange(3);
    }

    void permanentPan(int xfrom, int yfrom, int xto, int yto) {
        if (!this.trialPanning) {
            this.wcxtp = this.wcx;
            this.wcytp = this.wcy;
        }
        this.wcx = this.wcxtp - (this.wopx(xto) - this.wopx(xfrom));
        this.wcy = this.wcytp - (this.wopy(yto) - this.wopy(yfrom));
        this.trialPanning = false;
        this.rangeChange(3);
    }

    public int[] getIntPosition(double x, double y) {
        int[] ixy = new int[]{this.powx(x), this.powy(y)};
        return ixy;
    }

    protected final double xProj(double x, double y, double z) {
        return this.w2cx + this.m3xx * (x - this.w3cx) + this.m3xy * (y - this.w3cy) + this.m3xz * (z - this.w3cz);
    }

    protected final double yProj(double x, double y, double z) {
        return this.w2cy + this.m3yx * (x - this.w3cx) + this.m3yy * (y - this.w3cy) + this.m3yz * (z - this.w3cz);
    }

    protected final double zProj(double x, double y, double z) {
        return this.w2cz + this.m3zx * (x - this.w3cx) + this.m3zy * (y - this.w3cy) + this.m3zz * (z - this.w3cz);
    }

    public double[] project(double x, double y, double z) {
        double[] v = new double[]{this.xProj(x, y, z), this.yProj(x, y, z), this.zProj(x, y, z)};
        return v;
    }

    public double[] deProject(double x, double y, double z) {
        double xu = x - this.w2cx;
        double yu = y - this.w2cy;
        double zu = z - this.w2cz;
        double[] v = new double[3];
        double det = this.m3xx * (this.m3yy * this.m3zz - this.m3zy * this.m3yz) - this.m3xy * (this.m3yx * this.m3zz - this.m3zx * this.m3yz) + this.m3xz * (this.m3yx * this.m3zy - this.m3zx * this.m3yy);
        v[0] = this.w3cx + (this.m3xy * (this.m3yz * zu - this.m3zz * yu) - this.m3xz * (this.m3yy * zu - this.m3zy * yu) + xu * (this.m3yy * this.m3zz - this.m3zy * this.m3yz)) / det;
        v[1] = this.w3cy + -(this.m3xx * (this.m3yz * zu - this.m3zz * yu) - this.m3xz * (this.m3yx * zu - this.m3zx * yu) + xu * (this.m3yx * this.m3zz - this.m3zx * this.m3yz)) / det;
        v[2] = this.w3cz + (this.m3xx * (this.m3yy * zu - this.m3zy * yu) - this.m3xy * (this.m3yx * zu - this.m3zx * yu) + xu * (this.m3yx * this.m3zy - this.m3zx * this.m3yy)) / det;
        double wx = this.xProj(v[0], v[1], v[2]);
        double wy = this.yProj(v[0], v[1], v[2]);
        double wz = this.zProj(v[0], v[1], v[2]);
        if (Math.abs(det - 1.0) > 0.001) {
            E.warning("rotation determinant != 1. " + det);
        }
        if (Math.abs(x - wx) + Math.abs(y - wy) + Math.abs(z - wz) > 0.001) {
            E.info("matrix projection error: ");
            E.info("original " + x + " " + y + " " + z);
            E.info("deproj   " + v[0] + " " + v[1] + " " + v[2]);
            E.info("reproj   " + wx + " " + wy + " " + wz);
        }
        return v;
    }

    public void initializeRotation(int ixcen, int iycen) {
        double x = this.wopx(ixcen);
        double y = this.wopy(iycen);
        this.initializeRotation(x, y, 0.0);
    }

    public void initializeRotationLocal(double x, double y, double z) {
        this.initializeRotation(this.xProj(x, y, z), this.yProj(x, y, z), this.zProj(x, y, z));
    }

    public void initializeRotation(double x, double y, double z) {
        double[][] m3T = new double[][]{{this.m3xx, this.m3xy, this.m3xz}, {this.m3yx, this.m3yy, this.m3yz}, {this.m3zx, this.m3zy, this.m3zz}};
        this.m3B = m3T;
        double[] v = this.deProject(x, y, z);
        this.w2cx = x;
        this.w2cy = y;
        this.w2cz = 0.0;
        this.w3cx = v[0];
        this.w3cy = v[1];
        this.w3cz = v[2];
    }

    final void applyRotation(double[][] mr) {
        double[][] m3C = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    double[] dArray = m3C[i];
                    int n = j;
                    dArray[n] = dArray[n] + mr[i][k] * this.m3B[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.m3xx = m3C[0][0];
        this.m3xy = m3C[0][1];
        this.m3xz = m3C[0][2];
        this.m3yx = m3C[1][0];
        this.m3yy = m3C[1][1];
        this.m3yz = m3C[1][2];
        this.m3zx = m3C[2][0];
        this.m3zy = m3C[2][1];
        this.m3zz = m3C[2][2];
        if (this.rotationListener != null) {
            this.rotationListener.rotationChanged();
        }
    }

    final void axisRotate(double thax, double thr) {
        double cf = Math.cos(thax);
        double sf = Math.sin(thax);
        double cr = Math.cos(thr);
        double sr = Math.sin(thr);
        double[][] mr = new double[][]{{cf * cf + sf * cr * sf, cf * sf - sf * cr * cf, -sr * sf}, {sf * cf - cf * cr * sf, sf * sf + cf * cr * cf, cf * sr}, {sr * sf, -sr * cf, cr}};
        this.applyRotation(mr);
    }

    public void zRotate(double theta) {
        double cf = Math.cos(theta);
        double sf = Math.sin(theta);
        double[][] mr = new double[][]{{cf, sf, 0.0}, {-sf, cf, 0.0}, {0.0, 0.0, 1.0}};
        this.applyRotation(mr);
    }

    public void printRot() {
        E.info("rotmat: " + this.m3xx + " " + this.m3xy + " " + this.m3xz);
        E.info("        " + this.m3yx + " " + this.m3yy + " " + this.m3yz);
        E.info("        " + this.m3zx + " " + this.m3zy + " " + this.m3zz);
    }

    public void dragZRotate(int idx, int idy) {
        if (this.m3B == null) {
            return;
        }
        double theta = (double)idy / 60.0;
        this.zRotate(theta);
    }

    public void dragRollRotate(int idx, int idy) {
        if (this.m3B == null) {
            return;
        }
        double thax = Math.atan2(idx, idy);
        double thar = Math.sqrt(idx * idx + idy * idy) / 60.0;
        this.axisRotate(thax, thar);
    }

    public boolean visible3D(double x, double y, double z) {
        return Math.abs(1.5 * this.dpdwx * (this.xProj(x, y, z) - this.wcx)) < (double)this.width && Math.abs(1.5 * this.dpdwy * (this.yProj(x, y, z) - this.wcy)) < (double)this.height;
    }

    public double[][] getProjectionMatrix() {
        double[][] mat = new double[][]{{this.m3xx, this.m3xy, this.m3xz}, {this.m3yx, this.m3yy, this.m3yz}, {this.m3zx, this.m3zy, this.m3zz}};
        return mat;
    }

    public double[] get3Center() {
        double[] ret = new double[]{this.w3cx, this.w3cy, this.w3cz};
        return ret;
    }

    public double[] get2Center() {
        double[] ret = new double[]{this.w2cx, this.w2cy, this.w2cz};
        return ret;
    }

    public void setProjectionMatrix(double[][] pm) {
        this.m3xx = pm[0][0];
        this.m3xy = pm[0][1];
        this.m3xz = pm[0][2];
        this.m3yx = pm[1][0];
        this.m3yy = pm[1][1];
        this.m3yz = pm[1][2];
        this.m3zx = pm[2][0];
        this.m3zy = pm[2][1];
        this.m3zz = pm[2][2];
    }

    public void set3Center(double[] cen) {
        this.w3cx = cen[0];
        this.w3cy = cen[1];
        this.w3cz = cen[2];
    }

    public void set2Center(double[] cen) {
        this.w2cx = cen[0];
        this.w2cy = cen[1];
    }

    public void setScale(double sf) {
        this.dpdwx = sf;
        this.dpdwy = sf;
    }

    public double getScale() {
        return Math.sqrt(this.dpdwx * this.dpdwy);
    }
}

