/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.icon.splash;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.catacomb.icon.splash.SplashWindow;
import org.catacomb.report.E;

public class Splash
implements Runnable {
    String imgsrc;
    SplashWindow splashWindow;

    public Splash(String s, String fnm) {
        this.imgsrc = String.valueOf(s.replaceAll("\\.", "/")) + "/" + fnm;
    }

    public void show() {
        InputStream fis = ClassLoader.getSystemResourceAsStream(this.imgsrc);
        try {
            BufferedImage bim = ImageIO.read(fis);
            Frame frame = new Frame();
            this.splashWindow = new SplashWindow(bim, frame);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension windowSize = this.splashWindow.getPreferredSize();
            this.splashWindow.setLocation(screenSize.width / 2 - windowSize.width / 2, screenSize.height / 2 - windowSize.height / 2);
            this.splashWindow.packShow();
            Thread th = new Thread(this);
            th.start();
        }
        catch (Exception ex) {
            E.error("cant read splash " + this.imgsrc + " " + ex);
        }
    }

    @Override
    public void run() {
        try {
            Thread.sleep(4000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.splashWindow.setVisible(false);
    }

    public void hide() {
        this.splashWindow.setVisible(false);
    }
}

