/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import org.catacomb.be.Direction;

public class Heading {
    double hx;
    double hy;

    public Heading() {
        this.set(0.0, 1.0);
    }

    public Heading(double x, double y) {
        this.set(x, y);
    }

    public void set(double x, double y) {
        double d = Math.sqrt(x * x + y * y);
        this.hx = x / d;
        this.hy = y / d;
    }

    public String toString() {
        return "heading(" + this.hx + ", " + this.hy + ")";
    }

    public Direction getDirection() {
        return new Direction(this.hx, this.hy);
    }

    public double getX() {
        return this.hx;
    }

    public double getY() {
        return this.hy;
    }

    public void setBearing(double deg) {
        double rad = deg / 180.0 * Math.PI;
        double xv = Math.sin(rad);
        double yv = Math.cos(rad);
        this.set(xv, yv);
    }

    public double getBearing() {
        double b = Heading.makeBearing(this.hx, this.hy);
        return b;
    }

    public static double makeBearing(double vx, double vy) {
        double rad = Math.atan2(vx, vy);
        double deg = 180.0 * (rad / Math.PI);
        if (deg < 0.0) {
            deg += 360.0;
        }
        return deg;
    }

    public Heading getOpposite() {
        return new Heading(-1.0 * this.hx, -1.0 * this.hy);
    }
}

