/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.catacomb.interlish.structure.SettableStructure;
import org.catacomb.report.E;

public class ReflectionWrapper
implements SettableStructure {
    Object target;
    String fullClassname;
    Class<?> m_cls;
    static Class[] emptyCA = new Class[0];
    static Object[] emptyOA = new Object[0];

    public ReflectionWrapper(String pkg, String cnm) {
        String fcnm = cnm;
        if (pkg != null && pkg.length() > 0) {
            fcnm = String.valueOf(pkg) + "." + cnm;
        }
        this.fullClassname = fcnm;
        try {
            this.m_cls = Class.forName(fcnm);
            this.target = this.m_cls.newInstance();
        }
        catch (Exception ex) {
            E.error(" - can't construct " + fcnm + " " + ex);
        }
    }

    public boolean isOK() {
        return this.target != null;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public String getTypeName() {
        return this.fullClassname;
    }

    @Override
    public Object get(String s) {
        return this.getByGetter(s);
    }

    @Override
    public Object getStatic(String s) {
        return this.getDirectly(s);
    }

    public Object getDirectly(String s) {
        Object ret = null;
        try {
            Field fld = this.m_cls.getField(s);
            ret = fld.get(this.target);
        }
        catch (Exception ex) {
            System.out.println("WARNING - cant get (direct access) field " + s + " on " + this.target);
        }
        return ret;
    }

    public Object getByGetter(String s) {
        Object ret = null;
        String mnm = "get" + s;
        try {
            Method m = this.m_cls.getMethod(mnm, emptyCA);
            ret = m.invoke(this.target, emptyOA);
        }
        catch (Exception ex) {
            System.out.println("WARNING - cant get (getter method) field " + s + " on " + this.target);
        }
        return ret;
    }

    @Override
    public void set(String s, Object val) {
        this.setBySetter(s, val);
    }

    @Override
    public void setContext(String s, Object val) {
        E.missing();
    }

    public void setBySetter(String s, Object val) {
        if (val == null) {
            return;
        }
        String fl = s.substring(0, 1);
        String mnm = "set" + fl.toUpperCase() + s.substring(1, s.length());
        Class<Number> argcls = null;
        argcls = val instanceof Double ? Double.TYPE : (val instanceof Integer ? Integer.TYPE : (val instanceof Boolean ? Integer.TYPE : val.getClass()));
        Class[] ca = new Class[]{argcls};
        Object[] args = new Object[]{val};
        try {
            Method m = this.m_cls.getMethod(mnm, ca);
            m.invoke(this.target, args);
        }
        catch (Exception ex) {
            System.out.println("WARNING - cant set field " + s + " on " + this.target + " by executing " + mnm + " with arg " + val + " " + val.getClass().getName() + " " + ex);
        }
    }
}

