/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.service;

import java.util.HashMap;
import org.catacomb.act.ScriptStubs;
import org.catacomb.be.Instantiator;
import org.catacomb.interlish.service.ScriptChecker;
import org.catacomb.interlish.service.ScriptInfo;
import org.catacomb.interlish.service.ScriptMerger;
import org.catacomb.interlish.service.ScriptReport;
import org.catacomb.interlish.service.ScriptSource;
import org.catacomb.report.E;

public class ScriptManager {
    static ScriptManager instance;
    private HashMap<String, ScriptSource> sourceHM = new HashMap();
    private ScriptMerger scriptMerger;
    private ScriptChecker scriptChecker;
    private ScriptInfo scriptInfo;
    private Instantiator typeInstantiator;
    private Instantiator modelInstantiator;

    public static ScriptManager get() {
        if (instance == null) {
            instance = new ScriptManager();
        }
        return instance;
    }

    public void addUtility(Object obj) {
        if (obj instanceof ScriptMerger) {
            this.scriptMerger = (ScriptMerger)obj;
        } else if (obj instanceof ScriptChecker) {
            this.scriptChecker = (ScriptChecker)obj;
        } else if (obj instanceof ScriptInfo) {
            this.scriptInfo = (ScriptInfo)obj;
        } else {
            E.warning("unknown utility? " + obj);
        }
    }

    public ScriptInfo getScriptInfo() {
        return this.scriptInfo;
    }

    public void setModelInstantiator(Instantiator inst) {
        this.modelInstantiator = inst;
    }

    public Instantiator getModelInstantiator() {
        if (this.modelInstantiator == null) {
            E.error("asked for instantiator before it is set?");
        }
        return this.modelInstantiator;
    }

    public void setTypeInstantiator(Instantiator inst) {
        this.typeInstantiator = inst;
    }

    public Instantiator getTypeInstantiator() {
        if (this.typeInstantiator == null) {
            E.error("asked for instantiator before it is set?");
        }
        return this.typeInstantiator;
    }

    public ScriptReport checkScripts(Object obj) {
        ScriptReport ret = null;
        if (this.scriptChecker != null) {
            ret = this.scriptChecker.checkScript(obj);
        }
        return ret;
    }

    public void addScriptSource(Object hostExample, ScriptSource p) {
        String hcnm = null;
        hcnm = hostExample instanceof String ? (String)hostExample : hostExample.getClass().getName();
        this.sourceHM.put(hcnm, p);
    }

    private ScriptSource getScriptSource(Object host, int role) {
        ScriptSource ss = null;
        String hcl = host.getClass().getName();
        if (this.sourceHM.containsKey(hcl)) {
            ss = this.sourceHM.get(hcl);
        } else {
            E.error("need to generate code for " + hcl + " but no suitable script source is registered");
        }
        return ss;
    }

    public ScriptStubs getStubs(Object host, int role) {
        ScriptStubs ret = null;
        ScriptSource ss = this.getScriptSource(host, role);
        if (ss != null) {
            ret = ss.getStubs(host, role);
        }
        return ret;
    }

    public String getStubInfo(Object host, int role) {
        String ret = null;
        ScriptSource ss = this.getScriptSource(host, role);
        if (ss != null) {
            ret = ss.getScriptInfo(host, role);
        }
        return ret;
    }

    public String mergeStubs(String oldscript, String stubs) {
        return this.scriptMerger.mergeStubs(oldscript, stubs);
    }

    public void writeScripts(Object obj, int role) {
        ScriptSource ss = this.getScriptSource(obj, role);
        if (ss != null) {
            ss.writeScripts(obj);
        }
    }
}

