/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

public final class DoubleArray {
    double[] data;
    int npoint;

    public DoubleArray() {
        this.data = new double[100];
        this.npoint = 0;
    }

    public DoubleArray(double[] da) {
        this.data = da;
        this.npoint = da.length;
    }

    public int getNPoint() {
        return this.npoint;
    }

    public double[] getData() {
        return this.data;
    }

    public void addPoint(double d) {
        if (this.data == null) {
            this.data = new double[100];
        }
        if (this.npoint == this.data.length) {
            double[] td = new double[2 * this.data.length];
            System.arraycopy(this.data, 0, td, 0, this.npoint);
            this.data = td;
        }
        this.data[this.npoint++] = d;
    }

    public double getValue(int n) {
        return n >= 0 && n < this.npoint ? this.data[n] : 0.0;
    }

    public double[] getCutDownArray() {
        double[] da = new double[this.npoint];
        System.arraycopy(this.data, 0, da, 0, this.npoint);
        return da;
    }
}

