/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.model;

import java.util.ArrayList;
import org.catacomb.numeric.difnet.NetState;
import org.catacomb.numeric.difnet.model.PointCurrentStim;
import org.catacomb.numeric.difnet.model.PointStim;
import org.catacomb.numeric.difnet.model.PointVoltageStim;
import org.catacomb.numeric.function.ScalarFunction;
import org.catacomb.report.E;

public class BasicNetStim {
    ArrayList<PointStim> pointStims = new ArrayList();

    public void addCurrentStim(String id, String tag, String probePort, ScalarFunction sfg) {
        this.pointStims.add(new PointCurrentStim(id, tag, probePort, sfg));
    }

    public void addVoltageStim(String id, String tag, String probePort, ScalarFunction sf) {
        this.pointStims.add(new PointVoltageStim(id, tag, probePort, sf));
    }

    public void resolve(int[] remeshMap) {
        for (PointStim pr : this.pointStims) {
            String sp = pr.getPort();
            if (sp == null || sp.length() == 0) {
                E.warning("null port on probe " + pr);
                continue;
            }
            try {
                int ipt = Integer.parseInt(sp);
                if (ipt < 0) {
                    E.warning("negative port id in " + pr);
                    continue;
                }
                int iti = remeshMap[ipt];
                pr.setTargetIndex(iti);
            }
            catch (Exception ex) {
                E.error("must have integer port ids, not " + sp);
            }
        }
    }

    public void attachTo(NetState netState) {
        for (PointStim pr : this.pointStims) {
            int iti = pr.getTargetIndex();
            if (iti < 0) continue;
            pr.attachTo(netState.getNode(iti));
        }
    }
}

