/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.mesh;

import org.catacomb.interlish.structure.Mesh;
import org.catacomb.numeric.difnet.NetFactory;
import org.catacomb.numeric.difnet.NetStructure;
import org.catacomb.numeric.mesh.Discretizer;
import org.catacomb.numeric.mesh.MeshNetConverter;
import org.catacomb.numeric.mesh.MeshPoint;

public class DifMesh
implements Mesh {
    MeshPoint[] points;
    int[] indexTable;

    public void setPoints(MeshPoint[] dmpa) {
        this.points = dmpa;
    }

    public MeshPoint[] getPoints() {
        return this.points;
    }

    public MeshPoint getPoint(int ipt) {
        return this.points[ipt];
    }

    public int[] getRemeshMap() {
        if (this.indexTable == null) {
            this.makeIndexTable();
        }
        return this.indexTable;
    }

    private void makeIndexTable() {
        int maxp = -1;
        int np = this.points.length;
        int[] bufpa = new int[np];
        int i = 0;
        while (i < np) {
            int isrc = this.points[i].getIDIndex();
            if (isrc >= 0 && isrc < np) {
                bufpa[isrc] = i;
                if (isrc > maxp) {
                    maxp = isrc;
                }
            }
            ++i;
        }
        if (maxp < 0) {
            this.indexTable = new int[0];
        } else {
            this.indexTable = new int[maxp + 1];
            i = 0;
            while (i < maxp) {
                this.indexTable[i] = bufpa[i];
                ++i;
            }
        }
    }

    public void rediscretize(double disqrtr, int nmax) {
        MeshPoint[] mpa = Discretizer.discretize(this.points, disqrtr, nmax);
        this.points = mpa;
        this.indexTable = null;
    }

    public int getSize() {
        return this.points.length;
    }

    public NetStructure makeNetStructure(NetFactory nf) {
        NetStructure netStructure = MeshNetConverter.meshToNet(this.points, nf);
        return netStructure;
    }
}

