/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.catacomb.interlish.structure.Element;
import org.catacomb.interlish.structure.ElementWriter;
import org.catacomb.interlish.structure.Elementizer;
import org.catacomb.report.E;
import org.catacomb.serial.Reflector;
import org.catacomb.serial.SerialUtil;
import org.catacomb.serial.SerializationContext;
import org.catacomb.serial.om.OmElement;

public class OmElementizer
implements Elementizer {
    SerializationContext ctxt;

    public OmElementizer() {
        this.ctxt = new SerializationContext();
    }

    public OmElementizer(SerializationContext sc) {
        this.ctxt = sc;
    }

    public SerializationContext getContext() {
        return this.ctxt;
    }

    public Element getElement(Object obj) {
        return this.makeElement(obj);
    }

    public Element getFlatElement(Object obj) {
        this.ctxt.setPrimitivesOnly();
        return this.makeElement(obj);
    }

    public Element makeElement(Object objin) {
        Object obj = objin;
        Element retelt = null;
        if (obj instanceof char[]) {
            obj = new String((char[])obj);
        }
        if (obj instanceof String) {
            retelt = this.makeStringElement((String)obj);
        } else if (obj instanceof int[]) {
            retelt = this.makeIntArrayElement((int[])obj);
        } else if (obj instanceof double[]) {
            retelt = this.makeDoubleArrayElement((double[])obj);
        } else if (obj instanceof List) {
            retelt = this.makeListElement((List)obj);
        } else if (obj != null && obj.getClass().isArray()) {
            retelt = this.makeArrayElement(obj);
        } else if (obj instanceof Map) {
            E.error("Elementizer asked to elementize a raw map - shouldn't happen");
        } else if (obj != null) {
            retelt = this.makeObjectElement(obj);
        }
        return retelt;
    }

    private Element makeStringElement(String s) {
        OmElement elt = new OmElement("String");
        elt.addAttribute("value", s);
        return elt;
    }

    private Element makeIntArrayElement(int[] ia) {
        OmElement elt = new OmElement("IntegerArray");
        elt.addAttribute("values", SerialUtil.stringify(ia));
        return elt;
    }

    private Element makeDoubleArrayElement(double[] da) {
        OmElement elt = new OmElement("DoubleArray");
        elt.addAttribute("values", SerialUtil.stringify(da));
        return elt;
    }

    private Element makeListElement(List list) {
        OmElement listelt = new OmElement();
        for (Object listobj : list) {
            Element elt = this.makeElement(listobj);
            listelt.addElement(elt);
        }
        return listelt;
    }

    private Element makeArrayElement(Object arr) {
        ArrayList<Object> arl = new ArrayList<Object>();
        try {
            int nel = Array.getLength(arr);
            int i = 0;
            while (i < nel) {
                Object listobj = Array.get(arr, i);
                if (listobj != null) {
                    arl.add(listobj);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR - sand Reflector cant handle " + arr + " " + ex);
        }
        return this.makeListElement(arl);
    }

    private Element makeObjectElement(Object obj) {
        Element ret = null;
        ret = obj instanceof ElementWriter ? ((ElementWriter)obj).makeElement(this.ctxt.getElementFactory(), this) : Reflector.makeObjectElementByReflection(obj, this);
        return ret;
    }

    @Override
    public Element elementize(Object obj) {
        return this.makeObjectElement(obj);
    }
}

