/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.catacomb.report.E;
import org.catacomb.util.DirRef;
import org.catacomb.util.FileRef;
import org.catacomb.util.FileUtil;

public class FileAccumulator {
    File rootDir;
    ArrayList<File> allFiles;
    DirRef rootRef;
    HashSet<File> fileHS;

    public FileAccumulator(File rd) {
        this.rootDir = rd;
        this.rootRef = new DirRef("");
        this.allFiles = new ArrayList();
        this.fileHS = new HashSet();
    }

    public void addIfNew(File f) {
        if (!this.fileHS.contains(f)) {
            this.add(f);
        }
    }

    public void add(File f) {
        this.allFiles.add(f);
        this.fileHS.add(f);
        DirRef pd = this.rootRef;
        for (String s : FileUtil.getPathElements(this.rootDir, f)) {
            if (pd.containsDir(s)) {
                pd = pd.getDir(s);
                continue;
            }
            DirRef npd = new DirRef(s);
            pd.add(npd);
            pd = npd;
        }
        FileRef fr = new FileRef(f);
        pd.add(fr);
    }

    public void saveJar(File fzin) {
        File fz = fzin;
        if (!fz.getName().endsWith(".jar")) {
            fz = new File(fz.getParentFile(), String.valueOf(fz.getName()) + ".jar");
        }
        try {
            FileOutputStream fos = new FileOutputStream(fz);
            JarOutputStream zos = new JarOutputStream(fos);
            OutputStreamWriter osw = new OutputStreamWriter(zos);
            BufferedWriter bw = new BufferedWriter(osw);
            for (File f : this.allFiles) {
                String relpath = String.valueOf(FileUtil.getRelativeDirectory(f, this.rootDir)) + "/" + f.getName();
                String s = FileUtil.readStringFromFile(f);
                zos.putNextEntry(new JarEntry(relpath));
                bw.write(s, 0, s.length());
                bw.flush();
                zos.closeEntry();
            }
            osw.close();
        }
        catch (Exception ex) {
            E.error("jar write error " + ex);
        }
    }

    public void addJavaSource(String scrdir, String path) {
        File fsc = new File(this.rootDir, scrdir);
        String[] sa = path.split("\\.");
        int i = 0;
        while (i < sa.length - 1) {
            fsc = new File(fsc, sa[i]);
            ++i;
        }
        String sl = sa[sa.length - 1];
        if (sl.equals("*")) {
            if (fsc.exists() && fsc.isDirectory()) {
                File[] fileArray = fsc.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.addIfNew(f);
                    ++n2;
                }
            } else {
                E.warning("cant add wildcard imports " + path);
            }
        } else {
            File f = new File(fsc, String.valueOf(sl) + ".java");
            if (f.exists()) {
                this.addIfNew(f);
            } else {
                E.warning("missing script file? " + f + " for import " + path);
            }
        }
    }

    public void addJavaSourceSiblings(String scrdir, String pathin) {
        String path = pathin;
        if (path.endsWith(".*")) {
            this.addJavaSource(scrdir, path);
        } else {
            path = path.substring(0, path.lastIndexOf("."));
            path = String.valueOf(path) + ".*";
            this.addJavaSource(scrdir, path);
        }
    }
}

