/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.catacomb.interlish.structure.Tree;
import org.catacomb.interlish.structure.TreeChangeReporter;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.report.E;
import org.catacomb.util.StringTreeLeaf;

public class StringTree
implements Tree,
TreeNode {
    String path;
    String label;
    ArrayList<TreeNode> children;
    TreeNode parent;
    boolean exclude = false;

    public StringTree(String pth, String s) {
        this.path = pth;
        this.label = s;
        this.children = new ArrayList();
    }

    public void setExcluded() {
        this.exclude = true;
    }

    public String toString() {
        return this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPath() {
        return this.path;
    }

    public void addChild(TreeNode tn) {
        this.children.add(tn);
        if (tn instanceof StringTree) {
            ((StringTree)tn).setParent(this);
        } else if (tn instanceof StringTreeLeaf) {
            ((StringTreeLeaf)tn).setParent(this);
        } else {
            E.error("wrong child type? " + tn);
        }
    }

    public ArrayList<TreeNode> getChildren() {
        return this.children;
    }

    public int nChildren() {
        return this.children.size();
    }

    private StringTree getChildTree(String s) {
        StringTree ret = null;
        for (TreeNode obj : this.children) {
            if (!(obj instanceof StringTree) || !((StringTree)obj).getLabel().equals(s)) continue;
            ret = (StringTree)obj;
        }
        return ret;
    }

    public void addFromTokens(StringTokenizer st) {
        if (st.hasMoreTokens()) {
            String stok = st.nextToken();
            if (st.hasMoreTokens()) {
                StringTree sub = this.getChildTree(stok);
                if (sub == null) {
                    sub = new StringTree(String.valueOf(this.getPath()) + stok + ".", stok);
                    this.addChild(sub);
                }
                sub.addFromTokens(st);
            } else {
                this.addChild(new StringTreeLeaf(stok));
            }
        }
    }

    public void compress() {
        ArrayList<TreeNode> newChildren = new ArrayList<TreeNode>();
        for (TreeNode obj : this.children) {
            if (obj instanceof StringTreeLeaf) {
                newChildren.add((StringTreeLeaf)obj);
                continue;
            }
            if (!(obj instanceof StringTree)) continue;
            TreeNode oc = ((StringTree)obj).getCompressedForm();
            if (oc instanceof StringTree) {
                ((StringTree)oc).compress();
            }
            newChildren.add(oc);
        }
        this.children = newChildren;
    }

    public void partialFlatten() {
        ArrayList<TreeNode> newChildren = new ArrayList<TreeNode>();
        for (TreeNode obj : this.children) {
            if (obj instanceof StringTreeLeaf) {
                newChildren.add((StringTreeLeaf)obj);
                continue;
            }
            if (obj instanceof StringTree) {
                StringTree ost = (StringTree)obj;
                if (ost.nChildren() > 4) {
                    newChildren.add(ost);
                    continue;
                }
                newChildren.addAll(ost.getGrandchildrenAsChildren());
                continue;
            }
            E.error("dropped child? " + obj);
        }
        this.children = newChildren;
        for (TreeNode oc : this.children) {
            if (!(oc instanceof StringTree)) continue;
            ((StringTree)oc).partialFlatten();
        }
    }

    private TreeNode getCompressedForm() {
        TreeNode ret = this;
        while (this.children.size() == 1) {
            TreeNode obj = this.children.get(0);
            if (obj instanceof StringTree) {
                StringTree ct = (StringTree)obj;
                this.label = String.valueOf(this.label) + "." + ct.getLabel();
                this.children = ct.getChildren();
                this.path = ct.getPath();
                continue;
            }
            if (!(obj instanceof StringTreeLeaf)) continue;
            ret = new StringTreeLeaf(String.valueOf(this.label) + "." + ((StringTreeLeaf)obj).getLabel());
            break;
        }
        return ret;
    }

    public ArrayList<TreeNode> getGrandchildrenAsChildren() {
        ArrayList<TreeNode> ret = new ArrayList<TreeNode>();
        for (TreeNode ob : this.children) {
            if (ob instanceof StringTreeLeaf) {
                ret.add((StringTreeLeaf)ob);
                continue;
            }
            if (!(ob instanceof StringTree)) continue;
            StringTree chst = (StringTree)ob;
            for (TreeNode subch : chst.getChildren()) {
                if (subch instanceof StringTreeLeaf) {
                    ret.add(new StringTreeLeaf(String.valueOf(chst.getLabel()) + "." + subch));
                    continue;
                }
                if (!(subch instanceof StringTree)) continue;
                ((StringTree)subch).prefixLabel(String.valueOf(chst.getLabel()) + ".");
                ret.add((StringTree)subch);
            }
        }
        return ret;
    }

    private void prefixLabel(String pfx) {
        this.label = String.valueOf(pfx) + this.label;
    }

    public void print() {
        this.print("   ");
    }

    private void print(String indent) {
        System.out.println(String.valueOf(indent) + this.label + " (" + this.children.size() + "," + this.path + ")");
        for (TreeNode obj : this.children) {
            if (obj instanceof String) {
                System.out.println(String.valueOf(indent) + "   " + obj);
                continue;
            }
            ((StringTree)obj).print(String.valueOf(indent) + "   ");
        }
    }

    @Override
    public TreeNode getRoot() {
        return this;
    }

    @Override
    public int getRootPolicy() {
        return 1;
    }

    @Override
    public void setTreeChangeReporter(TreeChangeReporter tcr) {
    }

    @Override
    public Object[] getObjectPath(String s, boolean b) {
        E.warning("who needs the object path to " + s + " ?");
        return null;
    }

    public void setParent(TreeNode obj) {
        this.parent = obj;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Object getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.children.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.size() == 0;
    }
}

