/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.report;

public class E {
    public static long time0 = 0L;
    static String lastShortSource;
    static String cachedAction;
    static String lastErr;
    static int nrep;

    private static long getTime() {
        return System.currentTimeMillis();
    }

    public static void zeroTime() {
        time0 = E.getTime();
    }

    public static String getStringTime() {
        if (time0 == 0L) {
            E.zeroTime();
        }
        long dt = E.getTime() - time0;
        return "" + dt;
    }

    public static void info(String s) {
        System.out.println("INFO - " + s + E.getShortSource());
    }

    public static void infoTime(String s) {
        System.out.println("INFO - " + s + " at " + E.getStringTime());
    }

    public static void longInfo(String s) {
        System.out.println("INFO - " + s);
        E.showSource(16);
    }

    public static void message(String s) {
        System.out.println("MESSAGE - " + s);
    }

    public static void oneLineWarning(String s) {
        System.out.println("WARNING - " + s + E.getShortSource());
    }

    public static void shortWarning(String s) {
        System.out.println("WARNING - " + s + E.getShortSource());
    }

    public static void shortError(String s) {
        System.out.println("ERROR - " + s + E.getShortSource());
    }

    public static void medWarning(String s) {
        System.out.println("WARNING - " + s);
        E.showSource(4);
    }

    public static void warning(String s) {
        System.out.println("WARNING - " + s);
        E.showSource(12);
    }

    public static void linkToWarning(String s, Object obj) {
        System.out.println("WARNING - " + s);
        String fcn = obj.getClass().getName();
        String scn = fcn.substring(fcn.lastIndexOf(".") + 1, fcn.length());
        System.out.println("  at " + fcn + ".nomethod(" + scn + ".java:1)");
    }

    public static void error(String s) {
        if (lastErr != null && lastErr.equals(s)) {
            if (++nrep == 3 || nrep == 10 || nrep == 30 || nrep == 100) {
                System.out.println(" .......  last error repeated " + nrep + " times");
            }
        } else {
            if (nrep > 0) {
                System.out.println("total repeats of last error " + nrep);
            }
            nrep = 0;
            lastErr = s;
            System.out.println("ERROR - " + s);
            E.showSource();
        }
    }

    public static void debugError(String s) {
        System.out.println("ERROR - " + s);
        System.out.println("stack trace follows: ");
        E.stackTrace();
    }

    public static void fatalError(String s) {
        System.out.println("FATAL - " + s);
        E.stackTrace();
        System.exit(0);
    }

    public static void override(String s) {
        System.out.println("OVERRIDE - method should be overridden: " + s);
        E.showSource();
    }

    public static void override() {
        System.out.println("OVERRIDE - method should be overridden: ");
        E.showSource();
    }

    public static void deprecate(String s) {
        System.out.println("DEPRECATED - using deprecated class: " + s + " " + E.getShortSource());
        E.showShortSource();
    }

    public static void deprecate() {
        System.out.println("DEPRECATED - using deprecated method " + E.getShortSource());
        E.showShortSource();
    }

    public static void missing(String s) {
        System.out.println("MISSING - missing code needed: " + s);
        E.showSource();
    }

    public static void missing() {
        System.out.println("MISSING - missing code needed");
        E.showSource();
    }

    public static void stackTrace() {
        new Exception().printStackTrace();
    }

    public static void showSource() {
        E.showSource(10);
    }

    public static void showShortSource() {
        E.showSource(2);
    }

    public static void showSource(int n) {
        StackTraceElement[] stea = new Exception().getStackTrace();
        int i = 2;
        while (i < 2 + n && i < stea.length) {
            System.out.println("  at " + stea[i].toString());
            ++i;
        }
    }

    public static String getShortSource() {
        StackTraceElement[] stea = new Exception().getStackTrace();
        String ss = " at " + stea[2].toString();
        if (ss.equals(lastShortSource)) {
            ss = "";
        } else {
            lastShortSource = ss;
        }
        return ss;
    }

    public static void delay() {
        E.pause(200);
    }

    public static void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void newLine() {
        System.out.println("...");
    }

    public static void cacheAction(String s) {
        cachedAction = s;
    }

    public static void reportCached() {
        System.out.println("may relate to: " + cachedAction);
    }

    public static void dump(String[] labs) {
        if (labs != null) {
            int i = 0;
            while (i < labs.length) {
                System.out.println("element " + i + ": " + labs[i]);
                ++i;
            }
        }
    }

    public static void dump(String s, String[] labs) {
        System.out.println(String.valueOf(s) + " " + labs + " " + E.getShortSource());
        E.dump(labs);
    }

    public static void dump(String s, int[] ia) {
        System.out.println("int[] array: " + s + " " + ia.length + " " + E.getShortSource());
        int i = 0;
        while (i < ia.length) {
            System.out.println("   elt " + i + " = " + ia[i]);
            ++i;
        }
    }

    public static void dump(String s, double[] ia) {
        System.out.println("int[] array: " + s + " " + ia.length + " " + E.getShortSource());
        int i = 0;
        while (i < ia.length) {
            System.out.println("   elt " + i + " = " + ia[i]);
            ++i;
        }
    }

    public static void dump(String s, double[][] regcon) {
        int i = 0;
        while (i < regcon.length) {
            E.dump(String.valueOf(s) + "-" + i, regcon[i]);
            ++i;
        }
    }
}

