/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.disc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.textensor.report.E;
import org.textensor.stochdiff.disc.Resolution;
import org.textensor.stochdiff.disc.TreeUtil;
import org.textensor.stochdiff.numeric.morph.TreePoint;
import org.textensor.stochdiff.numeric.morph.VolumeGrid;
import org.textensor.stochdiff.numeric.morph.VolumeLine;

public class LineBoxer {
    TreePoint[] srcPoints;
    ArrayList<VolumeLine> gridAL;
    HashSet<TreePoint> wkpHS;
    double depth;
    Resolution resolution;

    public LineBoxer(TreePoint[] pts, double d2d) {
        this.srcPoints = pts;
        this.depth = d2d;
    }

    public VolumeGrid buildGrid(double d, HashMap<String, Double> resHM) {
        this.resolution = new Resolution(d, resHM);
        TreePoint firstpt = null;
        this.wkpHS = new HashSet();
        TreePoint[] treePointArray = this.srcPoints;
        int n = this.srcPoints.length;
        int n2 = 0;
        while (n2 < n) {
            TreePoint tp = treePointArray[n2];
            this.wkpHS.add(tp);
            if (firstpt == null && tp.isEndPoint()) {
                firstpt = tp;
            }
            ++n2;
        }
        TreeUtil.parentizeFrom(firstpt, this.srcPoints);
        this.gridAL = new ArrayList();
        VolumeLine vg0 = null;
        this.wkpHS.remove(firstpt);
        this.recAdd(vg0, firstpt);
        VolumeGrid vgr = new VolumeGrid();
        vgr.importLines(this.gridAL);
        return vgr;
    }

    private void recAdd(VolumeLine pGrid, TreePoint tp) {
        String lbl = tp.getLabel();
        tp.partBranchOffset = 0.0;
        for (TreePoint tpn : tp.getNeighbors()) {
            if (!this.wkpHS.contains(tpn)) continue;
            this.wkpHS.remove(tpn);
            if (lbl == null && tpn.nnbr == 1 && tpn.getLabel() != null) {
                lbl = tpn.getLabel();
            }
            VolumeLine vg = null;
            if (tpn.subAreaPeer != tp) {
                if (tp.subAreaPeer != null && tp.subAreaPeer == tp.parent) {
                    TreePoint par = tp.parent;
                    E.info("starting a sub-branch at " + tp + " - " + tpn + " " + pGrid);
                    vg = this.baseGrid(tp, tpn, lbl);
                    pGrid.subPlaneConnect(tp, tpn, vg, par.partBranchOffset);
                    par.partBranchOffset += 2.0 * tpn.r;
                } else if (pGrid == null) {
                    vg = this.baseGrid(tp, tpn, lbl);
                } else {
                    vg = this.baseGrid(tp, tpn, lbl);
                    pGrid.planeConnect(vg);
                }
            }
            lbl = null;
            if (vg != null) {
                this.gridAL.add(vg);
                this.recAdd(vg, tpn);
                continue;
            }
            this.recAdd(pGrid, tpn);
        }
    }

    public VolumeLine baseGrid(TreePoint tpa, TreePoint tpb, String lbl) {
        VolumeLine ret = null;
        double delta = this.resolution.getLocalDelta(tpa, tpb);
        String rgn = tpa.regionClassWith(tpb);
        ret = this.baseHardGrid(tpa, tpb, lbl, rgn, delta);
        return ret;
    }

    public VolumeLine baseHardGrid(TreePoint tpa, TreePoint tpb, String lbl, String rgn, double delta) {
        double r = 0.5 * (tpa.getRadius() + tpb.getRadius());
        int nd = 1 + 2 * (int)(r / delta);
        VolumeLine ret = new VolumeLine(nd, (double)nd * delta, this.depth);
        ret.lineFill(tpa, tpb, lbl, rgn);
        return ret;
    }

    public VolumeLine baseSoftGrid(TreePoint tpa, TreePoint tpb, String lbl, String rgn, double delta) {
        double r = 0.5 * (tpa.getRadius() + tpb.getRadius());
        int nd = (int)(2.0 * r / delta + 0.5);
        if (nd < 1) {
            nd = 1;
        }
        VolumeLine ret = new VolumeLine(nd, 2.0 * r, this.depth);
        ret.lineFill(tpa, tpb, lbl, rgn);
        return ret;
    }
}

