/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.inter.FloatValued;
import org.textensor.stochdiff.model.Concentration;

public class ConcentrationSet
implements AddableTo {
    public String region;
    public ArrayList<Concentration> concentrations;
    HashMap<String, Concentration> concHM;
    public boolean complete;

    @Override
    public void add(Object obj) {
        if (this.concentrations == null) {
            this.concentrations = new ArrayList();
        }
        if (obj instanceof Concentration) {
            this.concentrations.add((Concentration)obj);
        } else {
            E.error("cant add " + obj);
        }
    }

    public HashMap<String, Concentration> getConcHM() {
        if (this.concHM == null) {
            this.concHM = new HashMap();
            if (this.concentrations != null) {
                for (Concentration c : this.concentrations) {
                    this.concHM.put(c.specieID, c);
                }
            }
        }
        return this.concHM;
    }

    public double[] getNanoMolarConcentrations(String[] ids) {
        double[] ret = new double[ids.length];
        HashMap<String, Concentration> chm = this.getConcHM();
        int i = 0;
        while (i < ids.length) {
            ret[i] = chm.containsKey(ids[i]) ? chm.get(ids[i]).getNanoMolarConcentration() : -1.0;
            ++i;
        }
        return ret;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getRegion() {
        return this.region;
    }

    public void addFloatValued(ArrayList<FloatValued> afv) {
        afv.addAll(this.concentrations);
    }
}

