/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.model.Catalyst;
import org.textensor.stochdiff.model.Product;
import org.textensor.stochdiff.model.Reactant;
import org.textensor.stochdiff.model.Specie;
import org.textensor.stochdiff.model.SpecieRef;
import org.textensor.stochdiff.numeric.chem.ReactionTable;

public class Reaction
implements AddableTo {
    public String name;
    public String id;
    public String reactants;
    public String products;
    private ArrayList<Reactant> p_reactants;
    private ArrayList<Product> p_products;
    public Catalyst catalyst;
    public double forwardRate;
    public double reverseRate;
    public double michaelisConstant;
    public double Q10;
    private ArrayList<Specie> r_reactants;
    private ArrayList<Specie> r_products;
    private Specie r_catalyst;

    @Override
    public void add(Object obj) {
        if (obj instanceof Reactant) {
            if (this.p_reactants == null) {
                this.p_reactants = new ArrayList();
            }
            this.p_reactants.add((Reactant)obj);
        } else if (obj instanceof Product) {
            if (this.p_products == null) {
                this.p_products = new ArrayList();
            }
            this.p_products.add((Product)obj);
        } else if (obj instanceof Catalyst) {
            this.catalyst = (Catalyst)obj;
        } else {
            E.error("cant add " + obj);
        }
    }

    public void resolve(HashMap<String, Specie> sphm) {
        if (this.reactants != null) {
            this.r_reactants = this.parseList(this.reactants, sphm);
        } else if (this.p_reactants != null) {
            this.r_reactants = this.parseRefs(this.p_reactants, sphm);
        } else {
            E.error("no reactants? ");
        }
        if (this.products != null) {
            this.r_products = this.parseList(this.reactants, sphm);
        } else if (this.p_products != null) {
            this.r_products = this.parseRefs(this.p_products, sphm);
        } else {
            E.error("no reactants? ");
        }
        if (this.catalyst != null) {
            this.r_catalyst = sphm.get(this.catalyst.getSpecieID());
        }
    }

    private ArrayList<Specie> parseList(String lst, HashMap<String, Specie> sphm) {
        ArrayList<Specie> ret = new ArrayList<Specie>();
        StringTokenizer st = new StringTokenizer(lst, " ,");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (sphm.containsKey(tok)) {
                ret.add(sphm.get(tok));
                continue;
            }
            E.error("reaction " + this.name + " mentions unknown specie " + tok);
        }
        return ret;
    }

    private ArrayList<Specie> parseRefs(ArrayList<? extends SpecieRef> asr, HashMap<String, Specie> sphm) {
        ArrayList<Specie> ret = new ArrayList<Specie>();
        for (SpecieRef specieRef : asr) {
            if (sphm.containsKey(specieRef.getSpecieID())) {
                ret.add(sphm.get(specieRef.getSpecieID()));
                continue;
            }
            E.error("reaction " + this.name + " mentions unknown specie " + specieRef);
        }
        return ret;
    }

    private int[][] getIndices(ArrayList<Specie> spa, ArrayList<? extends SpecieRef> refs) {
        int n = spa.size();
        int[][] ret = new int[2][n];
        int i = 0;
        while (i < n) {
            ret[0][i] = spa.get(i).getIndex();
            ret[1][i] = 1;
            ++i;
        }
        if (refs != null) {
            i = 0;
            while (i < n) {
                ret[1][i] = refs.get(i).getN();
                ++i;
            }
        }
        return ret;
    }

    public void writeCatalyzedToTable(ReactionTable rtab, int ir) {
        int nr = this.r_reactants.size();
        int np = this.r_products.size();
        int icat = this.r_catalyst.getIndex();
        rtab.setCatalyzedReactionData(ir, nr, np, icat, this.getIndices(this.r_reactants, this.p_reactants), this.getIndices(this.r_products, this.p_products), this.michaelisConstant);
    }

    public void writeForwardToTable(ReactionTable rtab, int ir) {
        rtab.setReactionData(ir, this.getIndices(this.r_reactants, this.p_reactants), this.getIndices(this.r_products, this.p_products), this.forwardRate);
    }

    public void writeReverseToTable(ReactionTable rtab, int ir) {
        rtab.setReactionData(ir, this.getIndices(this.r_products, this.p_products), this.getIndices(this.r_reactants, this.p_reactants), this.reverseRate);
    }
}

