/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.model.Reaction;
import org.textensor.stochdiff.model.Specie;
import org.textensor.stochdiff.numeric.chem.ReactionTable;

public class ReactionScheme
implements AddableTo {
    public ArrayList<Specie> species = new ArrayList();
    HashMap<String, Specie> specieHM;
    public ArrayList<Reaction> reactions = new ArrayList();
    HashMap<String, Reaction> reactionHM;
    private Specie[] specieArray;

    @Override
    public void add(Object obj) {
        if (obj instanceof Specie) {
            this.species.add((Specie)obj);
        } else if (obj instanceof Reaction) {
            this.reactions.add((Reaction)obj);
        } else {
            E.error("cant add " + obj + " to reaction scheme ");
        }
    }

    public void resolve() {
        for (Reaction r : this.reactions) {
            r.resolve(this.getSpecieHM());
        }
    }

    public ArrayList<Specie> getSpecieList() {
        return this.species;
    }

    public ArrayList<Reaction> getReactionList() {
        return this.reactions;
    }

    public HashMap<String, Specie> getSpecieHM() {
        if (this.specieHM == null) {
            this.specieHM = new HashMap();
            for (Specie sp : this.species) {
                this.specieHM.put(sp.getID(), sp);
            }
        }
        return this.specieHM;
    }

    public String[] getSpeciesIDList() {
        String[] ret = new String[this.species.size()];
        int ict = 0;
        for (Specie sp : this.species) {
            ret[ict++] = sp.getID();
        }
        return ret;
    }

    public double[] getDiffusionConstants() {
        double[] ret = new double[this.species.size()];
        int ict = 0;
        for (Specie sp : this.species) {
            ret[ict++] = sp.getDiffusionConstant();
        }
        return ret;
    }

    public void indexSpecies() {
        this.specieArray = new Specie[this.species.size()];
        int ict = 0;
        Iterator<Specie> iterator = this.species.iterator();
        while (iterator.hasNext()) {
            Specie sp;
            this.specieArray[ict] = sp = iterator.next();
            sp.setIndex(ict);
            ++ict;
        }
    }

    public ReactionTable makeReactionTable() {
        if (this.specieArray == null) {
            this.indexSpecies();
        }
        int nreaction = this.reactions.size();
        int nspecie = this.species.size();
        ReactionTable rtab = new ReactionTable(2 * nreaction, nspecie);
        int ir = 0;
        for (Reaction r : this.reactions) {
            r.writeForwardToTable(rtab, ir);
            r.writeReverseToTable(rtab, ++ir);
            ++ir;
        }
        rtab.setSpeciesIDs(this.getSpeciesIDList());
        rtab.setDiffusionConstants(this.getDiffusionConstants());
        return rtab;
    }
}

