/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.model.Section;
import org.textensor.stochdiff.numeric.morph.SpineProfile;

public class SpineType
implements AddableTo {
    public String id;
    public ArrayList<Section> sections;
    private SpineProfile r_profile;

    @Override
    public void add(Object obj) {
        if (this.sections == null) {
            this.sections = new ArrayList();
        }
        if (obj instanceof Section) {
            this.sections.add((Section)obj);
        } else {
            E.error("cant add " + obj);
        }
    }

    public SpineProfile makeProfile() {
        int np = this.sections.size();
        double[] vl = new double[np];
        double[] vw = new double[np];
        String[] lbls = new String[np];
        String[] regions = new String[np];
        int i = 0;
        while (i < np) {
            Section sec = this.sections.get(i);
            vl[i] = sec.at;
            vw[i] = sec.width;
            if (sec.regionClass != null) {
                regions[i] = sec.regionClass;
            }
            if (sec.label != null) {
                lbls[i] = sec.label;
            }
            ++i;
        }
        SpineProfile ret = new SpineProfile(this.id, vl, vw, lbls, regions);
        return ret;
    }

    public SpineProfile getProfile() {
        if (this.r_profile == null) {
            this.r_profile = this.makeProfile();
        }
        return this.r_profile;
    }
}

