/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.neuroml;

import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.model.EndPoint;
import org.textensor.stochdiff.model.Segment;
import org.textensor.stochdiff.neuroml.MorphMLPoint;
import org.textensor.stochdiff.neuroml.MorphMLProperties;

public class segment
implements AddableTo {
    public String name;
    public String id;
    public String cable;
    public MorphMLPoint proximal;
    public MorphMLPoint distal;
    public String parent;
    public MorphMLProperties properties;

    @Override
    public void add(Object obj) {
        if (!(obj instanceof MorphMLProperties)) {
            E.warning("cant add " + obj);
        }
    }

    public String getID() {
        return this.id;
    }

    public String getParentID() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public MorphMLPoint getProximal() {
        return this.proximal;
    }

    public MorphMLPoint getDistal() {
        return this.distal;
    }

    public Segment getStochDiffSegment(HashMap<String, String> cableHM) {
        Segment ret = new Segment();
        ret.id = this.getID();
        if (this.cable != null) {
            if (cableHM.containsKey(this.cable)) {
                ret.region = cableHM.get(this.cable);
            } else {
                E.warning("segment refers to cable " + this.cable + " which can't be found");
            }
        }
        ret.start = new EndPoint(this.proximal.getID(), this.proximal.getX(), this.proximal.getY(), this.proximal.getZ(), this.proximal.getR());
        ret.end = new EndPoint(this.distal.getID(), this.distal.getX(), this.distal.getY(), this.distal.getZ(), this.distal.getR());
        if (this.parent != null) {
            ret.start.on = this.parent;
            ret.start.at = "end";
        }
        return ret;
    }
}

