/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.grid;

import org.textensor.report.E;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.BaseCalc;
import org.textensor.stochdiff.numeric.chem.ReactionTable;
import org.textensor.stochdiff.numeric.chem.StimulationTable;
import org.textensor.stochdiff.numeric.math.Column;
import org.textensor.stochdiff.numeric.math.MersenneTwister;
import org.textensor.stochdiff.numeric.morph.VolumeGrid;
import org.textensor.stochdiff.numeric.stochastic.InterpolatingStepGenerator;
import org.textensor.stochdiff.numeric.stochastic.StepGenerator;
import org.textensor.util.ArrayUtil;

public class SteppedStochaticGridCalc
extends BaseCalc {
    public static final double PARTICLES_PUVC = 0.6022;
    public static final double LN_PARTICLES_PUVC = Math.log(0.6022);
    public static final double CONC_OF_N = 1.6605778811026237;
    public static final double PARTICLES_PUASD = 0.6022;
    public static final int SHARED_DIFF_PARTICLES = 4;
    public static final int NP = 30;
    Column mconc;
    ReactionTable rtab;
    public VolumeGrid vgrid;
    StimulationTable stimTab;
    double dt;
    public int nel;
    int nspec;
    public String[] specieIDs;
    double[] volumes;
    double[] lnvolumes;
    double[] fdiff;
    double[] lnfdiff;
    double[] surfaceAreas;
    public boolean[] submembranes;
    public String[] regionLabels;
    public int[] eltregions;
    int[][] neighbors;
    double[][] couplingConstants;
    double[][] lnCC;
    int[][] wkA;
    int[][] wkB;
    int[] wkReac;
    int[][] nparticle;
    int nreaction;
    public int nspecie;
    String[] speciesIDs;
    double[] diffusionConstants;
    int[][] reactantIndices;
    int[][] productIndices;
    int[][] reactantStochiometry;
    int[][] productStochiometry;
    double[] rates;
    double[] lnrates;
    int[][] stimtargets;
    double[] intlogs;
    double lndt;
    int ninjected = 0;
    InterpolatingStepGenerator interpSG;
    MersenneTwister random;
    int nwarn;
    int nngowarn = 0;
    int ninfo;
    double[][] pSharedOut;
    double[][] lnpSharedOut;
    double[][][] fSharedExit;
    double stateSaveTime;

    public SteppedStochaticGridCalc(SDRun sdm) {
        super(sdm);
    }

    public final void init() {
        double[][] cc;
        this.stateSaveTime = this.sdRun.getStateSaveInterval();
        if (this.stateSaveTime <= 0.0) {
            this.stateSaveTime = 1.0E9;
        }
        this.random = new MersenneTwister(this.getCalculationSeed());
        this.rtab = this.getReactionTable();
        this.speciesIDs = this.rtab.getSpeciesIDs();
        this.nreaction = this.rtab.getNReaction();
        this.rates = this.rtab.getRates();
        this.lnrates = ArrayUtil.log(this.rates, -999.0);
        this.reactantIndices = this.rtab.getReactantIndices();
        this.productIndices = this.rtab.getProductIndices();
        this.reactantStochiometry = this.rtab.getReactantStochiometry();
        this.productStochiometry = this.rtab.getProductStochiometry();
        this.vgrid = this.getVolumeGrid();
        this.nel = this.vgrid.getNElements();
        this.nspec = this.rtab.getNSpecies();
        this.specieIDs = this.rtab.getSpecieIDs();
        this.volumes = this.vgrid.getElementVolumes();
        this.lnvolumes = ArrayUtil.log(this.volumes, -999.0);
        this.extractOutputScheme(this.rtab);
        this.surfaceAreas = this.vgrid.getExposedAreas();
        this.submembranes = this.vgrid.getSubmembranes();
        this.regionLabels = this.vgrid.getRegionLabels();
        this.fdiff = this.rtab.getDiffusionConstants();
        this.lnfdiff = ArrayUtil.log(this.fdiff, -999.0);
        this.neighbors = this.vgrid.getPerElementNeighbors();
        this.couplingConstants = this.vgrid.getPerElementCouplingConstants();
        this.lnCC = ArrayUtil.log(this.couplingConstants, -999.0);
        this.stimTab = this.getStimulationTable();
        this.stimtargets = this.vgrid.getAreaIndexes(this.stimTab.getTargetIDs());
        this.wkA = new int[this.nel][this.nspec];
        this.wkB = new int[this.nel][this.nspec];
        this.wkReac = new int[this.nreaction];
        this.eltregions = this.vgrid.getRegionIndexes();
        double[][] regcon = this.getRegionConcentrations();
        double[][] regsd = this.getRegionSurfaceDensities();
        int i = 0;
        while (i < this.nel) {
            double v = this.volumes[i];
            double[] rcs = regcon[this.eltregions[i]];
            int j = 0;
            while (j < this.nspec) {
                double rnp = v * rcs[j] * 0.6022;
                int irnp = (int)rnp;
                double drnp = rnp - (double)irnp;
                if ((double)this.random.random() < drnp) {
                    // empty if block
                }
                this.wkA[i][j] = ++irnp;
                this.wkB[i][j] = irnp;
                ++j;
            }
            double a = this.surfaceAreas[i];
            double[] scs = regsd[this.eltregions[i]];
            if (a > 0.0 && scs != null) {
                int j2 = 0;
                while (j2 < this.nspec) {
                    if (!Double.isNaN(scs[j2])) {
                        this.wkA[i][j2] = 0;
                        this.wkB[i][j2] = 0;
                        double rnp = a * scs[j2] * 0.6022;
                        int irnp = (int)rnp;
                        double drnp = rnp - (double)irnp;
                        if ((double)this.random.random() < drnp) {
                            ++irnp;
                        }
                        int[] nArray = this.wkA[i];
                        int n = j2;
                        nArray[n] = nArray[n] + irnp;
                        int[] nArray2 = this.wkB[i];
                        int n2 = j2;
                        nArray2[n2] = nArray2[n2] + irnp;
                    }
                    ++j2;
                }
            }
            ++i;
        }
        if (this.sdRun.initialStateFile != null && (cc = this.readInitialState(this.sdRun.initialStateFile, this.nel, this.nspec, this.speciesIDs)) != null) {
            int i2 = 0;
            while (i2 < this.nel) {
                int j = 0;
                while (j < this.nspec) {
                    int np;
                    this.wkA[i2][j] = np = (int)Math.round(cc[i2][j] * this.volumes[i2] / 1.6605778811026237);
                    this.wkB[i2][j] = np;
                    ++j;
                }
                ++i2;
            }
        }
        this.dt = this.sdRun.fixedStepDt;
        this.lndt = Math.log(this.dt);
        this.intlogs = new double[10000];
        this.intlogs[0] = -99.0;
        i = 1;
        while (i < this.intlogs.length) {
            this.intlogs[i] = Math.log(i);
            ++i;
        }
        if (this.useBinomial()) {
            this.interpSG = InterpolatingStepGenerator.getBinomialGenerator();
        } else if (this.usePoisson()) {
            this.interpSG = InterpolatingStepGenerator.getPoissonGenerator();
        } else {
            E.error("unknown probability distribution");
        }
        if (this.doShared() || this.doParticle() || this.doIndependent()) {
            int k;
            if (this.doShared()) {
                E.info("Using SHARED destination allocation");
            } else {
                E.info("Using PER PARTICLE destination allocation");
            }
            this.lnpSharedOut = new double[this.nel][this.nspec];
            this.pSharedOut = new double[this.nel][this.nspec];
            this.fSharedExit = new double[this.nel][this.nspec][];
            int maxnn = 0;
            int iel = 0;
            while (iel < this.nel) {
                k = 0;
                while (k < this.nspec) {
                    int nn = this.neighbors[iel].length;
                    this.fSharedExit[iel][k] = new double[nn];
                    if (nn > maxnn) {
                        maxnn = nn;
                    }
                    ++k;
                }
                ++iel;
            }
            E.info("max no of neighbors for a single element is " + maxnn);
            iel = 0;
            while (iel < this.nel) {
                k = 0;
                while (k < this.nspec) {
                    int[] inbr = this.neighbors[iel];
                    double[] lngnbr = this.lnCC[iel];
                    int nnbr = inbr.length;
                    double ptot = 0.0;
                    double[] pcnbr = new double[nnbr];
                    int j = 0;
                    while (j < nnbr) {
                        double lnpgo = this.lnfdiff[k] + lngnbr[j] + this.lndt - this.lnvolumes[iel];
                        double p = Math.exp(lnpgo);
                        pcnbr[j] = ptot += p;
                        ++j;
                    }
                    double lnptot = Math.log(ptot);
                    if (lnptot > -1.0) {
                        System.out.println("WK===================================");
                        System.out.println("In DIFFUSION: probability TOO HIGH!");
                        System.out.println("Reduce your timestep, and try again...");
                        System.out.println("WK====================================");
                        System.exit(0);
                    }
                    this.pSharedOut[iel][k] = ptot;
                    this.lnpSharedOut[iel][k] = lnptot;
                    int j3 = 0;
                    while (j3 < nnbr) {
                        this.fSharedExit[iel][k][j3] = pcnbr[j3] / ptot;
                        ++j3;
                    }
                    ++k;
                }
                ++iel;
            }
        }
    }

    private String getGridConcsText(double time) {
        StringBuffer sb = new StringBuffer();
        int nspecout = this.ispecout.length;
        if (nspecout == 0) {
            return "";
        }
        sb.append("gridConcentrations " + this.nel + " " + nspecout + " " + time + " ");
        int i = 0;
        while (i < nspecout) {
            sb.append(String.valueOf(this.specieIDs[this.ispecout[i]]) + " ");
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < nspecout) {
                if (this.writeConcentration) {
                    sb.append(this.stringd(1.6605778811026237 * (double)this.wkA[i][this.ispecout[j]] / this.volumes[i]));
                } else {
                    sb.append(this.stringi(this.wkA[i][this.ispecout[j]]));
                }
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    private String getGridConcsPlainText_dumb(int filenum, double time) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.stringd(time));
        int j = 0;
        while (j < this.specIndexesOut[filenum].length) {
            int i = 0;
            while (i < this.nel) {
                if (this.regionsOut[filenum].equals("default") || this.regionsOut[filenum].equals(this.regionLabels[this.eltregions[i]])) {
                    int npart = this.wkA[i][this.specIndexesOut[filenum][j]];
                    if (this.writeConcentration) {
                        sb.append(this.stringd(1.6605778811026237 * (double)npart / this.volumes[i]));
                    } else {
                        sb.append(this.stringi(npart));
                    }
                }
                ++i;
            }
            ++j;
        }
        sb.append("\n");
        return sb.toString();
    }

    private String getStateText() {
        StringBuffer sb = new StringBuffer();
        sb.append("nrds " + this.nel + " " + this.specieIDs.length + "\n");
        int i = 0;
        while (i < this.specieIDs.length) {
            sb.append(String.valueOf(this.specieIDs[i]) + " ");
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < this.specieIDs.length) {
                sb.append(this.stringd(1.6605778811026237 * (double)this.wkA[i][j] / this.volumes[i]));
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public final void run() {
        this.init();
        if (this.resultWriter != null) {
            this.resultWriter.writeString(this.vgrid.getAsText());
            this.resultWriter.writeToSiblingFileAndClose(this.vgrid.getAsTableText(), "-mesh.txt");
            int i = 0;
            while (i < this.fnmsOut.length) {
                this.resultWriter.writeToSiblingFile(this.getGridConcsHeadings_dumb(i, this.vgrid), "-" + this.fnmsOut[i] + "-conc.txt");
                ++i;
            }
        }
        double time = 0.0;
        double runtime = this.sdRun.runtime;
        double tlog = 5.0;
        long startTime = System.currentTimeMillis();
        double writeTime = -1.0E-9;
        double[] writeTimeArray = new double[this.fnmsOut.length];
        int i = 0;
        while (i < this.fnmsOut.length) {
            writeTimeArray[i] = -1.0E-9;
            ++i;
        }
        while (time < runtime) {
            if (time >= writeTime) {
                if (this.resultWriter != null) {
                    this.resultWriter.writeString(this.getGridConcsText(time));
                }
                writeTime += this.sdRun.outputInterval;
            }
            i = 0;
            while (i < this.fnmsOut.length) {
                if (time >= writeTimeArray[i]) {
                    this.resultWriter.writeToSiblingFile(this.getGridConcsPlainText_dumb(i, time), "-" + this.fnmsOut[i] + "-conc.txt");
                    int n = i;
                    writeTimeArray[n] = writeTimeArray[n] + Double.valueOf(this.dtsOut[i]);
                }
                ++i;
            }
            if ((time += this.advance(time)) > tlog) {
                E.info("time " + time + " dt=" + this.dt);
                tlog += Math.max(50.0 * this.sdRun.outputInterval, 5.0);
            }
            if (!(time >= this.stateSaveTime)) continue;
            this.resultWriter.writeToSiblingFile(this.getStateText(), String.valueOf(this.sdRun.stateSavePrefix) + Math.round(time) + ".nrds");
            this.stateSaveTime += this.sdRun.getStateSaveInterval();
        }
        long endTime = System.currentTimeMillis();
        E.info("total time " + (endTime - startTime) + "ms");
    }

    public double advance(double tnow) {
        double[][] stims = this.stimTab.getStimsForInterval(tnow, this.dt);
        int i = 0;
        while (i < stims.length) {
            double[] astim = stims[i];
            int j = 0;
            while (j < astim.length) {
                int nk;
                if (astim[j] > 0.0 && (nk = this.stimtargets[i].length) > 0) {
                    double as = astim[j] / (double)nk;
                    int ias = (int)as;
                    double asr = as - (double)((int)as);
                    int k = 0;
                    while (k < nk) {
                        int nin = ias + ((double)this.random.random() < asr ? 1 : 0);
                        this.ninjected += nin;
                        int[] nArray = this.wkA[this.stimtargets[i][k]];
                        int n = j;
                        nArray[n] = nArray[n] + nin;
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < this.nspec) {
                this.wkB[i][j] = this.wkA[i][j];
                ++j;
            }
            ++i;
        }
        int iel = 0;
        while (iel < this.nel) {
            int k = 0;
            while (k < this.nspec) {
                int np0;
                if (this.lnfdiff[k] > -90.0 && (np0 = this.wkA[iel][k]) > 0) {
                    if (this.algoID == 0) {
                        this.parallelAndSharedDiffusionStep(iel, k);
                    } else if (this.algoID == 1) {
                        this.parallelAndSharedDiffusionStep(iel, k);
                    } else if (this.algoID == 2) {
                        this.particleDiffusionStep(iel, k);
                    }
                }
                ++k;
            }
            ++iel;
        }
        i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < this.nspec) {
                this.wkA[i][j] = this.wkB[i][j];
                ++j;
            }
            ++i;
        }
        iel = 0;
        while (iel < this.nel) {
            double lnvol = this.lnvolumes[iel];
            int[] nstart = this.wkB[iel];
            int[] nend = this.wkA[iel];
            int isp = 0;
            while (isp < this.nspecie) {
                nend[isp] = nstart[isp];
                ++isp;
            }
            int ireac = 0;
            while (ireac < this.nreaction) {
                int[] ri = this.reactantIndices[ireac];
                int[] pi = this.productIndices[ireac];
                int[] rs = this.reactantStochiometry[ireac];
                int[] ps = this.productStochiometry[ireac];
                double lnp = this.lnrates[ireac] + this.lndt;
                int n = nstart[ri[0]];
                if (ri[1] >= 0) {
                    int nk = nstart[ri[1]];
                    if (nk < n) {
                        lnp += this.intlog(n);
                        n = nk;
                    } else {
                        lnp += this.intlog(nk);
                    }
                    lnp -= lnvol;
                    lnp -= LN_PARTICLES_PUVC;
                }
                if (lnp > -1.0) {
                    if (this.nwarn < 5) {
                        E.shortWarning("p too large at element " + iel + " reaction " + ireac + " capping from " + Math.exp(lnp) + " to " + " exp(-1.)");
                        ++this.nwarn;
                    }
                    lnp = -1.0;
                }
                if (n > 0) {
                    int pi1;
                    int pi0;
                    int ngo = 0;
                    if (n == 1) {
                        ngo = (double)this.random.random() < Math.exp(lnp) ? 1 : 0;
                    } else if (n < 120) {
                        ngo = this.interpSG.nGo(n, lnp, this.random.random());
                    } else if (this.useBinomial()) {
                        if ((double)n * Math.exp(lnp) < 30.0) {
                            ngo = StepGenerator.gaussianStep(n, Math.exp(lnp), this.random.gaussian(), this.random.random(), this.random.poisson((double)n * Math.exp(lnp)), 30);
                            if (ngo < 0) {
                                ngo = 0;
                                System.out.println("in advance (reaction), if (n*Math.exp(lnp)) < 30): ngo is NEGATIVE.");
                                System.out.println("ngo: " + ngo + " n: " + n + " Math.exp(lnp): " + Math.exp(lnp));
                            }
                        } else {
                            ngo = StepGenerator.gaussianStep(n, Math.exp(lnp), this.random.gaussian(), this.random.random());
                            if (ngo < 0) {
                                ngo = 0;
                                System.out.println("in advance (reaction), if (n*Math.exp(lnp)) >= 30): ngo is NEGATIVE.");
                                System.out.println("ngo: " + ngo + " n: " + n + " Math.exp(lnp): " + Math.exp(lnp));
                            }
                        }
                    } else {
                        ngo = StepGenerator.poissonStep(n, Math.exp(lnp), this.random.gaussian(), this.random.random());
                        if (ngo < 0) {
                            ngo = 0;
                            System.out.println("in advance (reaction), if not using binomial: ngo is NEGATIVE.");
                            System.out.println("ngo: " + ngo + " n: " + n + " Math.exp(lnp): " + Math.exp(lnp));
                        }
                    }
                    int ri0 = ri[0];
                    int ri1 = ri[1];
                    int rs0 = rs[0];
                    int rs1 = rs[1];
                    int navail = nend[ri0] / rs[0];
                    if (ri1 >= 0 && navail > nend[ri1] / rs1) {
                        navail = nend[ri1] / rs1;
                    }
                    if (ngo > navail) {
                        if (this.nwarn < 10) {
                            E.shortWarning("reaction " + ireac + " ran out of particles - need " + ngo + " but have " + navail);
                            ++this.nwarn;
                        }
                        ngo = navail;
                    }
                    if (ngo == 0) {
                        pi0 = pi[0];
                        pi1 = pi[1];
                        int n2 = ri0;
                        nend[n2] = nend[n2] - 0;
                        if (ri1 >= 0) {
                            int n3 = ri1;
                            nend[n3] = nend[n3] - 0;
                        }
                        int n4 = pi0;
                        nend[n4] = nend[n4] + 0;
                        if (pi1 >= 0) {
                            int n5 = pi1;
                            nend[n5] = nend[n5] + 0;
                        }
                    } else {
                        int n6 = ri0;
                        nend[n6] = nend[n6] - ngo * rs0;
                        if (ri1 >= 0) {
                            int n7 = ri1;
                            nend[n7] = nend[n7] - ngo * rs1;
                        }
                        if (nend[ri0] < 0) {
                            System.out.println("nend[ri0] is NEGATIVE!");
                        }
                        if (ri1 >= 0 && nend[ri1] < 0) {
                            System.out.println("nend[ri1] is NEGATIVE!");
                        }
                        pi0 = pi[0];
                        pi1 = pi[1];
                        int n8 = pi0;
                        nend[n8] = nend[n8] + ngo * ps[0];
                        if (pi1 >= 0) {
                            int n9 = pi1;
                            nend[n9] = nend[n9] + ngo * ps[1];
                        }
                    }
                }
                ++ireac;
            }
            ++iel;
        }
        return this.dt;
    }

    private final void parallelAndSharedDiffusionStep(int iel, int k) {
        int np0 = this.wkA[iel][k];
        int[] inbr = this.neighbors[iel];
        double[] fshare = this.fSharedExit[iel][k];
        int ngo = 0;
        int ngo_remaining = 0;
        boolean num_molecules_diffused_so_far = false;
        if (np0 == 1) {
            ngo = (double)this.random.random() < this.pSharedOut[iel][k] ? 1 : 0;
        } else if (np0 < 120) {
            ngo = this.interpSG.nGo(np0, Math.log(this.pSharedOut[iel][k]), this.random.random());
            if (ngo < 0) {
                System.out.println("in parallelAndSharedDiffusionStep 1st else: ngo is NEGATIVE from table. Exiting...");
                System.exit(0);
            }
        } else if (this.useBinomial()) {
            if ((double)np0 * this.pSharedOut[iel][k] < 30.0) {
                ngo = StepGenerator.gaussianStep(np0, this.pSharedOut[iel][k], this.random.gaussian(), this.random.random(), this.random.poisson((double)np0 * this.pSharedOut[iel][k]), 30);
                if (ngo < 0) {
                    ngo = 0;
                    System.out.println("in parallelAndSharedDiffusionStep, if (np0*pSharedOut[iel][k] < 30): ngo is NEGATIVE.");
                    System.out.println("ngo: " + ngo + " np0: " + np0 + " pSharedOut[iel][k]: " + this.pSharedOut[iel][k]);
                }
            } else {
                ngo = StepGenerator.gaussianStep(np0, this.pSharedOut[iel][k], this.random.gaussian(), this.random.random());
                if (ngo < 0) {
                    ngo = 0;
                    System.out.println("in parallelAndSharedDiffusionStep, if (np0*pSharedOut[iel][k] >= 30): ngo is NEGATIVE.");
                    System.out.println("ngo: " + ngo + " np0: " + np0 + " pSharedOut[iel][k]: " + this.pSharedOut[iel][k]);
                }
            }
        } else {
            ngo = StepGenerator.poissonStep(np0, this.pSharedOut[iel][k], this.random.gaussian(), this.random.random());
            if (ngo < 0) {
                ngo = 0;
                System.out.println("in parallelAndSharedDiffusionStep, if not using Binomial: ngo is NEGATIVE.");
                System.out.println("ngo: " + ngo + " np0: " + np0 + " pSharedOut[iel][k]: " + this.pSharedOut[iel][k]);
            }
        }
        if (ngo < 0) {
            System.out.println("in parallelAndSharedDiffusionStep: ngo is NEGATIVE. Should be impossible");
        }
        if (ngo > np0) {
            System.out.println("in parallelAndSharedDiffusionStep: nngo is greater than np0. This is bad");
        }
        if (ngo <= inbr.length * 4) {
            int[] nArray = this.wkB[iel];
            int n = k;
            nArray[n] = nArray[n] - ngo;
            int i = 0;
            while (i < ngo) {
                double r = this.random.random();
                int io = 0;
                while (r > fshare[io]) {
                    ++io;
                }
                int[] nArray2 = this.wkB[inbr[io]];
                int n2 = k;
                nArray2[n2] = nArray2[n2] + 1;
                ++i;
            }
        } else {
            ngo_remaining = ngo;
            double prev = 0.0;
            int j = 0;
            while (j < inbr.length - 1) {
                double pgoTmp = (this.fSharedExit[iel][k][j] - prev) / (this.fSharedExit[iel][k][inbr.length - 1] - prev);
                double lnpgosymmetry = Math.log(1.0 - pgoTmp);
                double lnpgo = Math.log(pgoTmp);
                prev = this.fSharedExit[iel][k][j];
                if (ngo_remaining < 120) {
                    ngo = ngo_remaining == 1 ? ((double)this.random.random() < this.fSharedExit[iel][k][j] ? 1 : 0) : (ngo_remaining == 0 ? 0 : (pgoTmp <= 0.5 ? this.interpSG.nGo(ngo_remaining, lnpgo, this.random.random()) : ngo_remaining - this.interpSG.nGo(ngo_remaining, lnpgosymmetry, this.random.random())));
                    if (ngo > ngo_remaining) {
                        if (this.nngowarn < 5) {
                            System.out.println("in parallelAndSharedDiffusionStep: INDEPENDENT: ngo > ngo_remaining, setting ngo=ngo_remaining ");
                        }
                        ngo = ngo_remaining;
                        ++this.nngowarn;
                    }
                    if (ngo < 0) {
                        System.out.println("in parallelAndSharedDiffusionStep Independent: ngo is NEGATIVE from table. ");
                    }
                } else if ((double)ngo_remaining * Math.exp(lnpgo) < 30.0) {
                    ngo = StepGenerator.gaussianStep(ngo_remaining, Math.exp(lnpgo), this.random.gaussian(), this.random.random(), this.random.poisson((double)ngo_remaining * Math.exp(lnpgo)), 30);
                    if (ngo < 0) {
                        ngo = 0;
                        System.out.println("in parallelAndSharedDiffusionStep, INDEPENDENT, if (ngo_remaining*Math.exp(lnpgo) < 30): ngo is NEGATIVE.");
                        System.out.println("ngo: " + ngo + " ngo_remaining: " + ngo_remaining + " Math.exp(lnpgo): " + Math.exp(lnpgo));
                    }
                    if (ngo > ngo_remaining) {
                        if (this.nngowarn < 5) {
                            System.out.println("in parallelAndSharedDiffusionStep: poisson: ngo > ngo_remaining, setting ngo=ngo_remaining ");
                        }
                        ngo = ngo_remaining;
                        ++this.nngowarn;
                    }
                } else {
                    ngo = StepGenerator.gaussianStep(ngo_remaining, Math.exp(lnpgo), this.random.gaussian(), this.random.random());
                    if (ngo < 0) {
                        ngo = 0;
                        System.out.println("in parallelAndSharedDiffusionStep, INDEPENDENT, if (ngo_remaining*Math.exp(lnpgo) >= 30): ngo is NEGATIVE.");
                        System.out.println("ngo: " + ngo + " ngo_remaining: " + ngo_remaining + " Math.exp(lnpgo): " + Math.exp(lnpgo));
                    }
                    if (ngo > ngo_remaining) {
                        if (this.nngowarn < 5) {
                            System.out.println("in parallelAndSharedDiffusionStep: gaussian: ngo > ngo_remaining, setting ngo=ngo_remaining ");
                        }
                        ngo = ngo_remaining;
                        ++this.nngowarn;
                    }
                }
                if (ngo < 0) {
                    System.out.println("in parallelAndSharedDiffusionStep INDEPENDENT: ngo is NEGATIVE. .");
                }
                int[] nArray = this.wkB[iel];
                int n = k;
                nArray[n] = nArray[n] - ngo;
                int[] nArray3 = this.wkB[inbr[j]];
                int n3 = k;
                nArray3[n3] = nArray3[n3] + ngo;
                ngo_remaining -= ngo;
                ++j;
            }
            ngo = ngo_remaining;
            int[] nArray = this.wkB[iel];
            int n = k;
            nArray[n] = nArray[n] - ngo;
            int[] nArray4 = this.wkB[inbr[inbr.length - 1]];
            int n4 = k;
            nArray4[n4] = nArray4[n4] + ngo;
            if (this.wkB[iel][k] < 0) {
                System.out.println("In INDEPENDENT DIFFUSION, wkB[iel][k] NEGATIVE!!!");
            }
        }
    }

    private final void parallelDiffusionStep(int iel, int k) {
        int[] inbr = this.neighbors[iel];
        double[] lngnbr = this.lnCC[iel];
        int nnbr = inbr.length;
        int np0 = this.wkA[iel][k];
        int j = 0;
        while (j < nnbr) {
            double lnpgo = this.lnfdiff[k] + lngnbr[j] + this.lndt - this.lnvolumes[iel];
            if (lnpgo > -1.0) {
                if (this.nwarn < 4) {
                    E.shortWarning("p too large at element " + iel + " transition " + j + " to  " + inbr[j] + " - capping " + Math.exp(lnpgo) + " coupling is " + lngnbr[j]);
                    ++this.nwarn;
                }
                lnpgo = -1.0;
            }
            int ngo = 0;
            ngo = np0 == 1 ? ((double)this.random.random() < Math.exp(lnpgo) ? 1 : 0) : (np0 < 120 ? this.interpSG.nGo(np0, lnpgo, this.random.random()) : (this.useBinomial() ? ((double)np0 * Math.exp(lnpgo) >= 10.0 ? StepGenerator.gaussianStep(np0, Math.exp(lnpgo), this.random.gaussian(), this.random.random()) : StepGenerator.gaussianStep(np0, Math.exp(lnpgo), this.random.gaussian(), this.random.random(), this.random.poisson((double)np0 * Math.exp(lnpgo)), 30)) : StepGenerator.poissonStep(np0, Math.exp(lnpgo), this.random.gaussian(), this.random.random())));
            if (ngo > this.wkB[iel][k]) {
                if (this.nwarn < 10) {
                    E.shortWarning("ran out of particles - curtailing last transition from " + ngo + " to " + this.wkB[iel][k] + " leaving point " + iel + " species " + k);
                } else if (this.nwarn == 10) {
                    E.info("Suppressing future warnings");
                }
                ++this.nwarn;
                ngo = this.wkB[iel][k];
            }
            int[] nArray = this.wkB[iel];
            int n = k;
            nArray[n] = nArray[n] - ngo;
            int[] nArray2 = this.wkB[inbr[j]];
            int n2 = k;
            nArray2[n2] = nArray2[n2] + ngo;
            ++j;
        }
    }

    private final void sharedDiffusionStep(int iel, int k) {
        int np0 = this.wkA[iel][k];
        int[] inbr = this.neighbors[iel];
        double[] fshare = this.fSharedExit[iel][k];
        double lnptot = this.lnpSharedOut[iel][k];
        int ngo = 0;
        ngo = np0 == 1 ? ((double)this.random.random() < Math.exp(lnptot) ? 1 : 0) : (np0 < 120 ? this.interpSG.nGo(np0, lnptot, this.random.random()) : (this.useBinomial() ? StepGenerator.gaussianStep(np0, Math.exp(lnptot), this.random.gaussian(), this.random.random()) : StepGenerator.poissonStep(np0, Math.exp(lnptot), this.random.gaussian(), this.random.random())));
        int[] nArray = this.wkB[iel];
        int n = k;
        nArray[n] = nArray[n] - ngo;
        int i = 0;
        while (i < ngo) {
            double r = this.random.random();
            int io = 0;
            while (r > fshare[io]) {
                ++io;
            }
            int[] nArray2 = this.wkB[inbr[io]];
            int n2 = k;
            nArray2[n2] = nArray2[n2] + 1;
            ++i;
        }
    }

    private final void particleDiffusionStep(int iel, int k) {
        int np0 = this.wkA[iel][k];
        int[] inbr = this.neighbors[iel];
        double[] fshare = this.fSharedExit[iel][k];
        double ptot = this.pSharedOut[iel][k];
        int i = 0;
        while (i < np0) {
            double r = this.random.random();
            if (r < ptot) {
                int[] nArray = this.wkB[iel];
                int n = k;
                nArray[n] = nArray[n] - 1;
                double fr = r / ptot;
                int io = 0;
                while (fr > fshare[io]) {
                    ++io;
                }
                int[] nArray2 = this.wkB[inbr[io]];
                int n2 = k;
                nArray2[n2] = nArray2[n2] + 1;
            }
            ++i;
        }
    }

    public final double intlog(int i) {
        double ret = 0.0;
        ret = i <= 0 ? -99.0 : (i < this.intlogs.length ? this.intlogs[i] : Math.log(i));
        return ret;
    }

    @Override
    public long getParticleCount() {
        long ret = 0L;
        int i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < this.nspec) {
                ret += (long)this.wkA[i][j];
                ++j;
            }
            ++i;
        }
        E.info("number injected = " + this.ninjected);
        return ret;
    }

    protected String getGridConcsHeadings_dumb(int filenum, VolumeGrid vgrid) {
        StringBuffer sb = new StringBuffer();
        sb.append("time");
        int j = 0;
        while (j < this.specIndexesOut[filenum].length) {
            int i = 0;
            while (i < this.nel) {
                if (this.regionsOut[filenum].equals("default") || this.regionsOut[filenum].equals(this.regionLabels[this.eltregions[i]])) {
                    String tempLabel;
                    sb.append(" Vol_" + i);
                    sb.append("_" + this.regionLabels[this.eltregions[i]]);
                    if (vgrid.getGroupID(i) != null) {
                        sb.append("." + vgrid.getGroupID(i));
                    } else if (vgrid.getLabel(i) != null && (tempLabel = vgrid.getLabel(i)).indexOf(".") > 0) {
                        sb.append("." + tempLabel.substring(0, tempLabel.indexOf(".")));
                    }
                    if (this.submembranes[i]) {
                        sb.append("_submembrane");
                    } else {
                        sb.append("_cytosol");
                    }
                    if (vgrid.getLabel(i) != null) {
                        tempLabel = vgrid.getLabel(i);
                        if (tempLabel.indexOf(".") > 0) {
                            sb.append("_" + tempLabel.substring(tempLabel.indexOf(".") + 1, tempLabel.length()));
                        } else {
                            sb.append("_" + vgrid.getLabel(i));
                        }
                    }
                    sb.append("_Spc_" + this.specieIDs[this.specIndexesOut[filenum][j]]);
                }
                ++i;
            }
            ++j;
        }
        sb.append("\n");
        return sb.toString();
    }
}

