/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.math;

import org.textensor.report.E;

public final class Column {
    int n;
    double[] dat;

    public Column(int n0) {
        this.n = n0;
        this.dat = new double[this.n];
    }

    public Column(double[] d) {
        this.dat = d;
        this.n = d.length;
    }

    public Column plus(double d) {
        double[] ret = new double[this.n];
        int i = 0;
        while (i < this.n) {
            ret[i] = this.dat[i] + d;
            ++i;
        }
        return new Column(ret);
    }

    public Column times(double d) {
        double[] ret = new double[this.n];
        int i = 0;
        while (i < this.n) {
            ret[i] = this.dat[i] * d;
            ++i;
        }
        return new Column(ret);
    }

    public void incrementBy(double d) {
        int i = 0;
        while (i < this.n) {
            int n = i++;
            this.dat[n] = this.dat[n] + d;
        }
    }

    public void incrementBy(double[] r) {
        int i = 0;
        while (i < this.n) {
            int n = i;
            this.dat[n] = this.dat[n] + r[i];
            ++i;
        }
    }

    public void incrementBy(Column v) {
        int i = 0;
        while (i < this.n) {
            int n = i;
            this.dat[n] = this.dat[n] + v.dat[i];
            ++i;
        }
    }

    public void multiuplyBy(double d) {
        int i = 0;
        while (i < this.n) {
            int n = i++;
            this.dat[n] = this.dat[n] * d;
        }
    }

    public double[] getData() {
        return this.dat;
    }

    public int size() {
        return this.n;
    }

    public double avgAbs() {
        double r = 0.0;
        int i = 0;
        while (i < this.n) {
            r += Math.abs(this.dat[i]);
            ++i;
        }
        return r /= (double)this.n;
    }

    public void decrementBy(Column v) {
        int i = 0;
        while (i < this.n) {
            int n = i;
            this.dat[n] = this.dat[n] - v.dat[i];
            ++i;
        }
    }

    public Column copy() {
        double[] d = new double[this.n];
        int i = 0;
        while (i < this.n) {
            d[i] = this.dat[i];
            ++i;
        }
        return new Column(d);
    }

    public void increment(int i, double d) {
        int n = i;
        this.dat[n] = this.dat[n] + d;
    }

    public Column plus(Column vdc) {
        Column ret = this.copy();
        ret.incrementBy(vdc);
        return ret;
    }

    public void print() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        while (i < this.n) {
            sb.append("" + this.dat[i]);
            if (i < this.n - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        E.info("column: " + sb.toString());
    }

    public void positivize() {
        int i = 0;
        while (i < this.n) {
            if (this.dat[i] < 0.0) {
                this.dat[i] = 0.0;
            }
            ++i;
        }
    }

    public void writeTo(double[] dout) {
        if (this.dat != dout) {
            int i = 0;
            while (i < this.n) {
                dout[i] = this.dat[i];
                ++i;
            }
        }
    }
}

