/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.morph;

import java.util.ArrayList;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.geom.Geom;
import org.textensor.stochdiff.numeric.morph.ElementConnection;
import org.textensor.stochdiff.numeric.morph.VolumeElement;
import org.textensor.stochdiff.numeric.morph.VolumeLine;
import org.textensor.stochdiff.numeric.morph.VolumeSlice;

public class VolumeGrid {
    public static final int GEOM_2D = 0;
    public static final int GEOM_3D = 1;
    ArrayList<VolumeElement> elements = new ArrayList();
    HashMap<String, ArrayList<VolumeElement>> regionHM = new HashMap();
    int nelement;
    String[] eltLabels;
    String[] eltGroupIDs;
    String[] regionLabels;
    int[] eltRegions;
    double[] volumes;
    double[][] positions;
    double[] exposedAreas;
    boolean[] submembranes;
    int nconnection;
    int[][] conI;
    double[] conG;
    int[][] eltNbrs;
    double[][] eltNbrG;
    HashMap<String, int[]> areaHM;

    public void importSlices(ArrayList<VolumeSlice> gridAL) {
        for (VolumeSlice vs : gridAL) {
            for (VolumeElement ve : vs.getElements()) {
                this.addVolumeElement(ve);
            }
        }
    }

    public void importLines(ArrayList<VolumeLine> gridAL) {
        for (VolumeLine vs : gridAL) {
            for (VolumeElement ve : vs.getElements()) {
                this.addVolumeElement(ve);
            }
        }
    }

    public void addElements(ArrayList<VolumeElement> veal) {
        for (VolumeElement ve : veal) {
            this.addVolumeElement(ve);
        }
    }

    private void addVolumeElement(VolumeElement ve) {
        this.elements.add(ve);
        String sr = ve.getRegion();
        if (sr != null) {
            if (this.regionHM.containsKey(sr)) {
                this.regionHM.get(sr).add(ve);
            } else {
                ArrayList<VolumeElement> ave = new ArrayList<VolumeElement>();
                ave.add(ve);
                this.regionHM.put(sr, ave);
            }
        }
    }

    public ArrayList<VolumeElement> getElementsInRegion(String reg) {
        ArrayList<VolumeElement> ret = null;
        ret = this.regionHM.containsKey(reg) ? this.regionHM.get(reg) : new ArrayList<VolumeElement>();
        return ret;
    }

    public void fix() {
        ArrayList<ElementConnection> connections = new ArrayList<ElementConnection>();
        for (VolumeElement ve : this.elements) {
            connections.addAll(ve.getConnections());
        }
        ArrayList<String> rA = new ArrayList<String>();
        rA.add("default");
        this.nelement = this.elements.size();
        this.volumes = new double[this.nelement];
        this.exposedAreas = new double[this.nelement];
        this.positions = new double[this.nelement][3];
        this.eltLabels = new String[this.nelement];
        this.eltGroupIDs = new String[this.nelement];
        this.eltRegions = new int[this.nelement];
        this.submembranes = new boolean[this.nelement];
        int i = 0;
        while (i < this.nelement) {
            VolumeElement ve = this.elements.get(i);
            this.volumes[i] = ve.getVolume();
            this.exposedAreas[i] = ve.getExposedArea();
            this.positions[i][0] = ve.getX();
            this.positions[i][1] = ve.getY();
            this.positions[i][2] = ve.getZ();
            this.eltLabels[i] = ve.getLabel();
            this.eltGroupIDs[i] = ve.getGroupID();
            this.submembranes[i] = ve.getSubmembrane();
            String sr = ve.getRegion();
            if (sr == null || sr.length() == 0) {
                this.eltRegions[i] = 0;
            } else if (rA.contains(sr)) {
                this.eltRegions[i] = rA.indexOf(sr);
            } else {
                int nn;
                this.eltRegions[i] = nn = rA.size();
                rA.add(sr);
            }
            ve.cache(i);
            ++i;
        }
        this.regionLabels = rA.toArray(new String[rA.size()]);
        this.makeAreaHM();
        this.nconnection = connections.size();
        this.conI = new int[this.nconnection][2];
        this.conG = new double[this.nconnection];
        i = 0;
        while (i < this.nconnection) {
            ElementConnection ec = (ElementConnection)connections.get(i);
            int ia = ec.getElementA().getCached();
            int ib = ec.getElementB().getCached();
            this.conI[i][0] = ia;
            this.conI[i][1] = ib;
            double d = Geom.distanceBetween(this.positions[ia], this.positions[ib]);
            this.conG[i] = ec.getContactArea() / d;
            ++i;
        }
        int[] nnbr = new int[this.nelement];
        int i2 = 0;
        while (i2 < this.nconnection) {
            int n = this.conI[i2][0];
            nnbr[n] = nnbr[n] + 1;
            int n2 = this.conI[i2][1];
            nnbr[n2] = nnbr[n2] + 1;
            ++i2;
        }
        this.eltNbrs = new int[this.nelement][];
        this.eltNbrG = new double[this.nelement][];
        i2 = 0;
        while (i2 < this.nelement) {
            this.eltNbrs[i2] = new int[nnbr[i2]];
            this.eltNbrG[i2] = new double[nnbr[i2]];
            ++i2;
        }
        int[] inbr = new int[this.nelement];
        int i3 = 0;
        while (i3 < this.nconnection) {
            int i1;
            int i0 = this.conI[i3][0];
            this.eltNbrs[i0][inbr[i0]] = i1 = this.conI[i3][1];
            this.eltNbrG[i0][inbr[i0]] = this.conG[i3];
            int n = i0;
            inbr[n] = inbr[n] + 1;
            this.eltNbrs[i1][inbr[i1]] = i0;
            this.eltNbrG[i1][inbr[i1]] = this.conG[i3];
            int n3 = i1;
            inbr[n3] = inbr[n3] + 1;
            ++i3;
        }
    }

    public int[] getRegionIndexes() {
        return this.eltRegions;
    }

    public int getNElements() {
        if (this.volumes == null) {
            E.error("grid not fixed - call fix explicitly");
        }
        return this.nelement;
    }

    public double[] getElementVolumes() {
        return this.volumes;
    }

    public double[] getExposedAreas() {
        return this.exposedAreas;
    }

    public boolean[] getSubmembranes() {
        return this.submembranes;
    }

    public int[][] getPerElementNeighbors() {
        return this.eltNbrs;
    }

    public double[][] getPerElementCouplingConstants() {
        return this.eltNbrG;
    }

    public int size() {
        return this.getNElements();
    }

    public String[] getRegionLabels() {
        return this.regionLabels;
    }

    public String getAsText() {
        StringBuffer sb = new StringBuffer();
        sb.append("volumeGrid " + this.nelement);
        sb.append("\n");
        int i = 0;
        while (i < this.nelement) {
            sb.append(this.elements.get(i).getAsText());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String getAsTableText() {
        StringBuffer sb = new StringBuffer();
        sb.append("element_index " + this.elements.get(0).getHeadings());
        sb.append("\n");
        int i = 0;
        while (i < this.nelement) {
            sb.append(i + " " + this.elements.get(i).getAsPlainText());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public String getLabel(int i) {
        return this.eltLabels[i];
    }

    public String getGroupID(int i) {
        return this.eltGroupIDs[i];
    }

    public int[][] getAreaIndexes(String[] targetIDs) {
        int[][] ret = new int[targetIDs.length][];
        int i = 0;
        while (i < targetIDs.length) {
            String sti = targetIDs[i];
            if (this.areaHM.containsKey(sti)) {
                ret[i] = this.areaHM.get(sti);
            } else if (sti.indexOf("[") >= 0) {
                int[] ms = this.getMatches(this.areaHM, sti);
                if (ms != null && ms.length > 0) {
                    ret[i] = ms;
                } else {
                    ret[i] = new int[0];
                    E.warning("There are no matches for target: " + sti);
                }
            } else {
                E.warning("An action is defined for area " + sti + " but there are no points with this label");
                ret[i] = new int[0];
            }
            ++i;
        }
        return ret;
    }

    private int[] getMatches(HashMap<String, int[]> areaHM, String sti) {
        ArrayList<Integer> aidx = new ArrayList<Integer>();
        int iob = sti.indexOf("[");
        int icb = sti.indexOf("]");
        String pre = sti.substring(0, iob + 1);
        String post = sti.substring(icb, sti.length());
        String range = sti.substring(iob + 1, icb);
        range = range.replace(" ", "");
        int rangemin = 0;
        int rangemax = -1;
        if (range.indexOf(":") >= 0) {
            String rpre = range.substring(0, range.indexOf(":"));
            String rpost = range.substring(range.indexOf(":") + 1, range.length());
            if (rpre.length() > 0) {
                rangemin = Integer.parseInt(rpre);
            }
            rangemax = rpost.length() > 0 ? Integer.parseInt(rpost) : 1000000;
        }
        for (String s : areaHM.keySet()) {
            if (!s.startsWith(pre) || !s.endsWith(post)) continue;
            String sin = s.substring(pre.length(), s.indexOf(post));
            int ind = Integer.parseInt(sin);
            boolean ok = false;
            if (rangemin <= ind && rangemax >= ind) {
                ok = true;
            } else if (("," + range + ",").indexOf("," + sin + ",") >= 0) {
                ok = true;
            }
            if (!ok) continue;
            int[] nArray = areaHM.get(s);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                aidx.add(i);
                ++n2;
            }
        }
        int na = aidx.size();
        int[] ret = new int[na];
        int i = 0;
        while (i < na) {
            ret[i] = (Integer)aidx.get(i);
            ++i;
        }
        return ret;
    }

    public void makeAreaHM() {
        HashMap idHM = new HashMap();
        int i = 0;
        while (i < this.nelement) {
            String sr;
            String sl = this.eltLabels[i];
            if (sl != null && sl.length() > 0) {
                if (!idHM.containsKey(sl)) {
                    idHM.put(sl, new ArrayList());
                }
                ((ArrayList)idHM.get(sl)).add(new Integer(i));
            }
            if ((sr = this.regionLabels[this.eltRegions[i]]) != null && sr.length() > 0) {
                if (!idHM.containsKey(sr)) {
                    idHM.put(sr, new ArrayList());
                }
                ((ArrayList)idHM.get(sr)).add(new Integer(i));
            }
            ++i;
        }
        this.areaHM = new HashMap();
        for (String s : idHM.keySet()) {
            ArrayList ali = (ArrayList)idHM.get(s);
            int[] ia = new int[ali.size()];
            int i2 = 0;
            while (i2 < ia.length) {
                ia[i2] = (Integer)ali.get(i2);
                ++i2;
            }
            this.areaHM.put(s, ia);
        }
    }
}

