/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.stochastic;

import org.textensor.report.E;
import org.textensor.stochdiff.numeric.stochastic.NGoTable;
import org.textensor.stochdiff.numeric.stochastic.StepGenerator;

public class InterpolatingStepGenerator
extends StepGenerator {
    public final double lnpmin = Math.log(1.0E-8);
    public static final double deltalnp = 0.03;
    public final double lnpmax = Math.log(0.5);
    NGoTable[][] pnTable;
    int nppts;
    private static InterpolatingStepGenerator bInstance;
    private static InterpolatingStepGenerator pInstance;

    public static InterpolatingStepGenerator getBinomialGenerator() {
        if (bInstance == null) {
            bInstance = new InterpolatingStepGenerator(0);
        }
        return bInstance;
    }

    public static InterpolatingStepGenerator getPoissonGenerator() {
        if (pInstance == null) {
            pInstance = new InterpolatingStepGenerator(1);
        }
        return pInstance;
    }

    public InterpolatingStepGenerator(int mode) {
        if (mode == 0) {
            E.info("Using a BINOMIAL step generator");
        } else {
            E.info("Using a POISSON step generator");
        }
        this.nppts = (int)((this.lnpmax - this.lnpmin) / 0.03 + 2.0);
        this.pnTable = new NGoTable[this.nppts + 1][121];
        this.fullInit(mode);
    }

    private void fullInit(int mode) {
        int i = 0;
        while (i <= this.nppts) {
            double lnp = this.lnpmin + (double)i * 0.03;
            int j = 2;
            while (j <= 120) {
                this.pnTable[i][j] = new NGoTable(j, lnp, mode);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int nGo(int n, double lnp, double r) {
        int ia = (int)((lnp - this.lnpmin) / 0.03);
        double f = (lnp - (this.lnpmin + (double)ia * 0.03)) / 0.03;
        if (ia < 0) {
            ia = 0;
            f = 0.0;
        }
        int ngo = 0;
        if (n > 120) {
            E.error("n too large");
        } else {
            if (ia + 1 > this.nppts) {
                E.error("ia too big " + n + " " + lnp + " " + r);
            }
            if (n == 1) {
                System.out.println("nppts: " + this.nppts);
                System.out.println("ia: " + ia);
                System.out.println("n: " + n);
                System.out.println("r: " + r);
            }
            double rna = this.pnTable[ia][n].rnGo(r);
            double rnb = this.pnTable[ia + 1][n].rnGo(r);
            ngo = (int)(f * rnb + (1.0 - f) * rna);
        }
        return ngo;
    }

    public void timeTest() {
        int n = 10;
        while (n <= 90) {
            int ip = -6;
            while (ip <= -1) {
                double lnp = 1.0 * (double)ip;
                long t0 = System.currentTimeMillis();
                double rnx = 1.0E7;
                int njt = 0;
                int k = 0;
                while ((double)k < rnx) {
                    njt += this.nGo(n, lnp, (double)k / rnx);
                    ++k;
                }
                long t1 = System.currentTimeMillis();
                System.out.println("timings " + n + " " + lnp + " " + (t1 - t0));
                int k2 = 0;
                while (k2 <= 5) {
                    double r = 0.001 + 0.99 * ((double)k2 / 5.0);
                    int ia = (int)((lnp - this.lnpmin) / 0.03);
                    if (ia < 0) {
                        ia = 0;
                    }
                    int ina = this.pnTable[ia][n].nGo(r);
                    double rna = this.pnTable[ia][n].rnGo(r);
                    double rnb = this.pnTable[ia + 1][n].rnGo(r);
                    System.out.println(" lnp, n, deltango " + lnp + " " + n + " " + ina + " " + (rnb - rna));
                    ++k2;
                }
                ++ip;
            }
            n += 20;
        }
    }

    public void dumpTable(int n, double lnp) {
        int ia = (int)((lnp - this.lnpmin) / 0.03);
        double f = (lnp - (this.lnpmin + (double)ia * 0.03)) / 0.03;
        if (ia < 0) {
            ia = 0;
            f = 0.0;
        }
        E.info("interpolationg between tables " + ia + " and " + (ia + 1) + " factor " + f);
        this.pnTable[ia][n].print();
        this.pnTable[ia + 1][n].print();
    }
}

