/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.stochastic;

public abstract class StepGenerator {
    protected static final int BINOMIAL = 0;
    protected static final int POISSON = 1;
    public static final int NMAX_STOCHASTIC = 120;

    public abstract int nGo(int var1, double var2, double var4);

    public static int gaussianStep(int n, double p, double grv, double urv) {
        int ngo;
        double rngo = p * (double)n + grv * Math.sqrt((double)n * p * (1.0 - p));
        if (rngo - (double)(ngo = (int)rngo) > urv) {
            ++ngo;
        }
        return ngo;
    }

    public static int gaussianStep(int n, double p, double grv, double urv, double prv, int np) {
        int ngo;
        double rngo = 0.0;
        rngo = (double)n * p < (double)np ? prv : p * (double)n + grv * Math.sqrt((double)n * p * (1.0 - p));
        if (rngo - (double)(ngo = (int)rngo) > urv) {
            ++ngo;
        }
        return ngo;
    }

    public static int poissonStep(int n, double p, double grv, double urv) {
        int ngo;
        double rngo = (double)n * p + grv * Math.sqrt((double)n * p);
        if (rngo - (double)(ngo = (int)rngo) > urv) {
            ++ngo;
        }
        return ngo;
    }
}

