/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.util;

public class ArrayUtil {
    public static double[] log(double[] d, double dzero) {
        double[] ret = new double[d.length];
        int i = 0;
        while (i < d.length) {
            ret[i] = d[i] <= 0.0 ? dzero : Math.log(d[i]);
            ++i;
        }
        return ret;
    }

    public static double[][] log(double[][] d, double dzero) {
        double[][] ret = new double[d.length][];
        int i = 0;
        while (i < d.length) {
            ret[i] = ArrayUtil.log(d[i], dzero);
            ++i;
        }
        return ret;
    }

    public static int findBracket(double[] v, double x) {
        if (v == null || v.length == 0) {
            return -1;
        }
        int n = v.length;
        int ret = 0;
        if (x < v[0]) {
            ret = -1;
        } else if (x > v[n - 1]) {
            ret = n - 1;
        } else {
            int ia = 0;
            int ib = n - 1;
            while (ib - ia > 1) {
                int ic = (ia + ib) / 2;
                if (x <= v[ic]) {
                    ib = ic;
                    continue;
                }
                ia = ic;
            }
            ret = ia;
        }
        return ret;
    }

    public static double[] span(double xa, double xb, int nel) {
        double[] ret = new double[nel + 1];
        double dx = (xb - xa) / (double)nel;
        int i = 0;
        while (i < nel + 1) {
            ret[i] = xa + (double)i * dx;
            ++i;
        }
        return ret;
    }

    public static double[] interpInAtFor(double[] aw, double[] ax, double[] xbd) {
        int np = xbd.length;
        int ns = ax.length;
        double[] ret = new double[np];
        int i = 0;
        while (i < np) {
            double x = xbd[i];
            int ipos = 0;
            while (ipos < ns - 2 && x > ax[ipos + 1]) {
                ++ipos;
            }
            double f = (x - ax[ipos]) / (ax[ipos + 1] - ax[ipos]);
            ret[i] = f * aw[ipos + 1] + (1.0 - f) * aw[ipos];
            ++i;
        }
        return ret;
    }

    public static boolean arraysMatch(String[] a, String[] b) {
        boolean ret = false;
        if (a.length == b.length) {
            ret = true;
            int i = 0;
            while (i < a.length) {
                if (!a[i].equals(b[i])) {
                    ret = false;
                }
                ++i;
            }
        }
        return ret;
    }
}

