/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.act;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.catacomb.act.ArrayDeclaration;
import org.catacomb.act.DefaultConstructor;
import org.catacomb.act.FieldSignature;
import org.catacomb.act.MethodSignature;
import org.catacomb.act.ScriptStubs;
import org.catacomb.act.SignatureComparator;
import org.catacomb.act.SuperCallConstructor;
import org.catacomb.report.E;

public class Classdef {
    String info;
    String packageName;
    String className;
    String subclassName;
    String extendsName = null;
    String qualifier = "";
    SuperCallConstructor constructor;
    SuperCallConstructor subConstructor;
    DefaultConstructor econstructor;
    DefaultConstructor esubConstructor;
    ArrayList<FieldSignature> fields;
    HashMap<String, ArrayDeclaration> arrayDecs;
    ArrayList<MethodSignature> methods;
    public ArrayList<String> imports = new ArrayList();
    ArrayList<String> implementsNames = new ArrayList();
    String subclassImports;

    public Classdef() {
        this.fields = new ArrayList();
        this.arrayDecs = new HashMap();
        this.methods = new ArrayList();
    }

    public void setPackage(String s) {
        this.packageName = s;
    }

    public void setQualifier(String s) {
        this.qualifier = s;
    }

    public void addImplements(String s) {
        this.addImplementsName(s);
    }

    public void setClassName(String s) {
        this.className = s;
    }

    public String getClassName() {
        return this.className;
    }

    public void setSubclassName(String s) {
        this.subclassName = s;
    }

    public void setSuperclassName(String s) {
        this.extendsName = s;
    }

    public void addImplementsName(String s) {
        this.implementsNames.add(s);
    }

    public void addField(FieldSignature ms) {
        this.fields.add(ms);
    }

    public void addMethod(MethodSignature ms) {
        this.methods.add(ms);
    }

    public MethodSignature getMethod(String mnm) {
        MethodSignature ret = null;
        for (MethodSignature ms : this.methods) {
            if (!ms.getName().equals(mnm)) continue;
            ret = ms;
            break;
        }
        return ret;
    }

    public void addImport(Object obj) {
        if (obj instanceof Class) {
            this.addStringImport(((Class)obj).getName());
        } else {
            this.addStringImport(obj.getClass().getName());
        }
    }

    public void addStringImport(String s) {
        if (!this.imports.contains(s)) {
            this.imports.add(s);
        }
    }

    private String makePackageStatement() {
        return "package " + this.packageName + ";\n";
    }

    private String makeJavaImports() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.imports) {
            if (s.equals(String.valueOf(this.packageName) + "." + this.className) || s.equals(String.valueOf(this.packageName) + ".*")) continue;
            sb.append("import ");
            sb.append(s);
            sb.append(";\n");
        }
        return sb.toString();
    }

    public void setInfo(String msg) {
        this.info = msg;
    }

    public MethodSignature newMethod(String mnm) {
        MethodSignature ms = new MethodSignature(mnm);
        this.addMethod(ms);
        return ms;
    }

    public MethodSignature newShowMethod(String rtype, String mnm, String atype) {
        MethodSignature ms = new MethodSignature(mnm, 3);
        ms.setReturnType(rtype);
        if (atype != null) {
            ms.addArgument(atype, "v");
        }
        this.addMethod(ms);
        return ms;
    }

    public MethodSignature newReadMethod(String rtype, String mnm, String atype) {
        MethodSignature ms = new MethodSignature(mnm, 2);
        ms.setReturnType(rtype);
        this.addMethod(ms);
        return ms;
    }

    public MethodSignature newSendMethod(String mnm, String atype) {
        MethodSignature ms = new MethodSignature(mnm, 4);
        ms.setReturnType("void");
        if (atype != null) {
            ms.addArgument(atype, "v");
        }
        this.addMethod(ms);
        return ms;
    }

    public MethodSignature newReceiveMethod(String mnm, String atype) {
        MethodSignature ms = new MethodSignature(mnm, 1);
        ms.setReturnType("void");
        if (atype != null) {
            ms.addArgument(atype, "v");
        }
        this.addMethod(ms);
        return ms;
    }

    public FieldSignature newPrivateField(String typ, String nm) {
        FieldSignature fsig = new FieldSignature(typ, nm);
        fsig.setPrivate();
        this.addField(fsig);
        return fsig;
    }

    public FieldSignature newPublicField(String typ, String nm) {
        FieldSignature fsig = new FieldSignature(typ, nm);
        fsig.setPublic();
        this.addField(fsig);
        return fsig;
    }

    public FieldSignature newReflectableField(String typ, String nm) {
        FieldSignature fsig = new FieldSignature(typ, nm);
        fsig.setReflectable();
        this.addField(fsig);
        return fsig;
    }

    public FieldSignature newGetSetField(String typ, String nm) {
        FieldSignature fsig = new FieldSignature(typ, nm);
        fsig.addGetter();
        fsig.addSetter();
        this.addField(fsig);
        return fsig;
    }

    public String writeSystemSource() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.makePackageStatement());
        sb.append("\n");
        sb.append(this.makeJavaImports());
        sb.append("\n");
        sb.append("//IMPORTS\n");
        if (this.info != null) {
            sb.append("/*\n" + this.info + "\n*/\n");
        }
        sb.append("public " + this.qualifier + " class " + this.className + " ");
        if (this.extendsName != null) {
            sb.append("extends " + this.extendsName + " ");
        }
        if (this.implementsNames != null && this.implementsNames.size() > 0) {
            sb.append("implements ");
            boolean follower = false;
            for (String s : this.implementsNames) {
                if (follower) {
                    sb.append(",");
                }
                follower = true;
                sb.append(" " + s);
            }
        }
        sb.append(" {\n\n");
        for (FieldSignature fsig : this.fields) {
            sb.append(fsig.getJavaSource());
        }
        for (ArrayDeclaration ad : this.arrayDecs.values()) {
            sb.append(ad.toJava());
        }
        sb.append("\n\n");
        if (this.constructor != null) {
            sb.append(this.constructor.toJavaSource(this.className));
            sb.append("\n\n");
        }
        if (this.econstructor != null) {
            sb.append(this.econstructor.toJavaSource(this.className));
            sb.append("\n\n");
        }
        Collections.sort(this.methods, new SignatureComparator());
        for (FieldSignature fsig : this.fields) {
            sb.append(fsig.getJavaAccessors());
        }
        for (MethodSignature ms : this.methods) {
            String qf = "";
            if (ms.isRequiredUser()) {
                qf = " abstract ";
            }
            if (ms.isSuper() || ms.superDefined() && ms.emptyBody()) continue;
            sb.append(ms.toJavaSource(qf));
            sb.append("\n\n");
        }
        sb.append("//LINE " + this.nlines(sb) + " start of user content\n");
        sb.append("//CLASSBODY\n");
        sb.append("}\n");
        return sb.toString();
    }

    public String writeSubSource() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.makePackageStatement());
        sb.append("\n");
        sb.append(this.makeJavaImports());
        sb.append("\n");
        if (this.subclassImports != null) {
            sb.append(this.subclassImports);
            sb.append("\n");
        }
        sb.append("//IMPORTS\n");
        if (this.info != null) {
            sb.append("/*\n" + this.info + "\n*/\n");
        }
        sb.append("public class " + this.subclassName + " ");
        sb.append("extends " + this.className + " ");
        sb.append(" {\n\n");
        if (this.subConstructor != null) {
            sb.append(this.subConstructor.toJavaSource(this.subclassName));
            sb.append("\n\n");
        }
        if (this.esubConstructor != null) {
            sb.append(this.esubConstructor.toJavaSource(this.subclassName));
            sb.append("\n\n");
        }
        sb.append("//CLASSBODY\n");
        sb.append("\n\n");
        sb.append("}\n");
        return sb.toString();
    }

    public String writeSystemFieldComments() {
        return this.writeSystemFieldComments("p");
    }

    public String writeSystemFieldComments(String pname) {
        StringBuffer sb = new StringBuffer();
        int npf = 0;
        if (this.fields != null) {
            for (FieldSignature fsig : this.fields) {
                if (!fsig.isPublic() || !fsig.isVisible()) continue;
                sb.append("");
                sb.append(fsig.getPrefixedInfo(pname));
                sb.append("<br>\n");
                ++npf;
            }
        }
        return sb.toString();
    }

    public int countAccessibleFields() {
        int nf = 0;
        for (FieldSignature fsig : this.fields) {
            if (!fsig.isPublic() || !fsig.isVisible()) continue;
            ++nf;
        }
        return nf;
    }

    public String writeLocalFieldComments() {
        StringBuffer sb = new StringBuffer();
        for (FieldSignature fsig : this.fields) {
            if (!fsig.isPublic() || !fsig.isVisible()) continue;
            sb.append("");
            sb.append(fsig.getLocalInfo());
            sb.append("<br>\n");
        }
        if (sb.length() == 0) {
            sb.append(" - no local fields - ");
        }
        return sb.toString();
    }

    public String writeSystemSignatures() {
        StringBuffer sb = new StringBuffer();
        for (MethodSignature msig : this.methods) {
            if (!msig.isSuper() && (!msig.isSystem() || !msig.isUserAccessible())) continue;
            sb.append("");
            sb.append(msig.writeCommentSignature());
            sb.append("<br>\n");
        }
        if (sb.length() == 0) {
            sb.append(" - no access methods - <br>");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String writeSubSourceMethods() {
        StringBuffer sb = new StringBuffer();
        for (MethodSignature msig : this.methods) {
            if (!msig.isUser() && !msig.isRequiredUser()) continue;
            sb.append(msig.toJavaSource());
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public ScriptStubs getSubSourceMethodStubs() {
        ScriptStubs ret = new ScriptStubs();
        for (MethodSignature msig : this.methods) {
            if (!msig.isUser() && !msig.isRequiredUser()) continue;
            ret.add(msig.getStub());
        }
        return ret;
    }

    public void addSuperCallConstructor() {
        this.addSuperCallConstructor(null);
    }

    public void addSuperCallConstructor(String argtype) {
        this.constructor = new SuperCallConstructor(argtype);
        this.subConstructor = new SuperCallConstructor(argtype);
    }

    public void addSuperCallConstructor(String argtype, String body) {
        this.constructor = new SuperCallConstructor(argtype, body);
        this.subConstructor = new SuperCallConstructor(argtype);
    }

    public void addDefaultConstructor(String sbody) {
        this.econstructor = new DefaultConstructor(sbody);
    }

    public void addDefaultConstructor() {
        this.econstructor = new DefaultConstructor();
        this.esubConstructor = new DefaultConstructor();
    }

    public void startArrayDeclaration(String sType, String sName) {
        ArrayDeclaration arrDec = new ArrayDeclaration(sName);
        arrDec.setType(sType);
        this.arrayDecs.put(sName, arrDec);
    }

    public void addToArray(String anm, String aval) {
        if (this.arrayDecs.containsKey(anm)) {
            this.arrayDecs.get(anm).addValue(aval);
        } else {
            E.warning("no sucn array declaration : " + anm);
        }
    }

    public FieldSignature addGetSetField(String st, String sn) {
        FieldSignature fsig = new FieldSignature(st, sn);
        fsig.addGetter();
        fsig.addSetter();
        fsig.setPublic();
        this.addField(fsig);
        return fsig;
    }

    public void setUserHidden(String methname) {
        this.getMethod(methname).setUserHidden();
    }

    public void appendToBody(String methname, String line) {
        MethodSignature msig = this.getMethod(methname);
        if (msig == null) {
            msig = new MethodSignature(methname);
            this.addMethod(msig);
        }
        msig.appendToBody(line);
    }

    public void addSubclassImports(String s) {
        this.subclassImports = this.subclassImports == null ? s : String.valueOf(this.subclassImports) + "\n" + s;
    }

    private int nlines(StringBuffer sb) {
        String s = sb.toString();
        int nocc = 0;
        int ioff = s.indexOf("\n");
        while (ioff >= 0) {
            ++nocc;
            ioff = s.indexOf("\n", ioff + 1);
        }
        return nocc;
    }
}

