/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.awt.Color;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.PlotElement;
import org.catacomb.graph.gui.Painter;

public class RasterRowElement
extends PlotElement {
    double[] xpts;
    double[] vals;
    double vmin;
    double vmax;
    double y0;
    double thresh;

    public RasterRowElement(double[] x, double[] v, double a, double b, double y, double th) {
        this.vmin = a;
        this.vmax = b;
        this.y0 = y;
        this.xpts = x;
        this.vals = v;
        this.thresh = th;
    }

    @Override
    public void instruct(Painter p) {
        Color[] cols = new Color[256];
        int i = 0;
        while (i < 256) {
            cols[i] = new Color(i, i, i);
            ++i;
        }
        i = 0;
        while (i < this.xpts.length - 2) {
            double v = this.vals[i];
            double fv = (v - this.vmin) / (this.vmax - this.vmin);
            if (fv < 0.0) {
                fv = 0.0;
            }
            if (fv > 1.0) {
                fv = 1.0;
            }
            p.fillRectangle(this.xpts[i], this.y0, this.xpts[i + 1], this.y0 + 0.8, cols[(int)(255.0 * fv)]);
            ++i;
        }
        p.setColor(Color.yellow);
        i = 0;
        while (i < this.xpts.length - 2) {
            if (this.vals[i] < this.thresh && this.vals[i + 1] >= this.thresh) {
                p.drawLine(this.xpts[i], this.y0, this.xpts[i], this.y0 + 0.8);
            }
            ++i;
        }
    }

    @Override
    public void push(Box b) {
        b.pushX(this.xpts);
        b.pushY(this.y0 + 1.0);
        b.pushY(this.y0);
    }
}

