/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.blocks;

import org.catacomb.druid.blocks.AbstractButton;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.edit.DruToggleButton;

public class ToggleButton
extends AbstractButton {
    public String group;
    public String store;
    public String value;
    public boolean initial;
    public String offImage;
    public String onImage;
    public String groupAction;

    public ToggleButton() {
    }

    public ToggleButton(String slab) {
        super(slab);
    }

    @Override
    public DruPanel instantiatePanel() {
        return new DruToggleButton(this.label, this.action);
    }

    @Override
    public void populatePanel(DruPanel dp, Context ctx, GUIPath gpath) {
        DruToggleButton drup = (DruToggleButton)dp;
        if (this.image != null) {
            drup.setOffImage(this.image);
        } else if (this.offImage != null) {
            drup.setOffImage(this.offImage);
        }
        if (this.onImage != null) {
            drup.setOnImage(this.onImage);
        }
        this.applyPadding(drup);
        if (this.group != null) {
            drup.setToggle(this.group, this.value);
            drup.setContingencyGroup(ctx.getContingencyGroup(this.group));
            if (this.initial) {
                drup.setInitialValue(true);
            }
        }
        if (this.groupAction != null) {
            drup.setGroupAction(this.groupAction);
        }
        drup.setEffects(this.realizeEffects(this.effects, ctx, gpath));
        if (this.title == null || this.title.length() == 0) {
            drup.setTitle(String.valueOf(this.label) + " Button");
        }
        drup.setInitialValue(this.initial);
    }
}

