/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.base;

import java.awt.Color;
import org.catacomb.druid.gui.base.DruBorderPanel;
import org.catacomb.interlish.interact.Workbench;
import org.catacomb.interlish.structure.AssemblyEditor;
import org.catacomb.interlish.structure.ModeController;
import org.catacomb.report.E;

public class DruAssemblyPanel
extends DruBorderPanel
implements AssemblyEditor {
    static final long serialVersionUID = 1001L;
    Workbench workbench;
    int prefw;
    int prefh;
    Color bgc;
    Color canvasColor;
    Color shelfColor;
    ModeController modeController;

    public DruAssemblyPanel(int w, int h, String bsName) {
        this.prefw = w;
        this.prefh = h;
    }

    public void setWorkbench(Workbench wkb) {
        this.workbench = wkb;
        this.workbench.setPreferredSize(this.prefw, this.prefh);
        this.addDComponent(this.workbench, "Center");
        this.applyToWorkbench();
    }

    private void applyToWorkbench() {
        if (this.bgc != null) {
            this.workbench.setBg(this.bgc);
            this.workbench.setSunkenBorder(this.bgc);
        }
        if (this.modeController != null) {
            this.workbench.setModeController(this.modeController);
        }
        if (this.canvasColor != null) {
            this.workbench.setCanvasColor(this.canvasColor);
        }
        if (this.shelfColor != null) {
            this.workbench.setShelfColor(this.shelfColor);
        }
        if (this.infoReceiver != null) {
            this.workbench.setInfoReceiver(this.infoReceiver);
        }
    }

    @Override
    public void setBg(Color c) {
        super.setBg(c);
        this.bgc = c;
        if (this.workbench != null) {
            this.workbench.setBg(c);
            this.workbench.setSunkenBorder(c);
        }
    }

    @Override
    public void postApply() {
        if (this.workbench != null) {
            this.applyToWorkbench();
        }
    }

    public void setModeController(ModeController mc) {
        this.modeController = mc;
        if (this.workbench != null) {
            this.workbench.setModeController(mc);
        }
    }

    public void setAssembly(Object ass) {
        if (this.workbench != null) {
            this.workbench.setAssembly(ass);
        } else {
            E.error("must have workbench before setting assembly");
        }
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    public void setCanvasColor(Color color) {
        this.canvasColor = color;
        if (this.workbench != null) {
            this.workbench.setCanvasColor(color);
        }
    }

    public void setShelfColor(Color color) {
        this.shelfColor = color;
        if (this.workbench != null) {
            this.workbench.setShelfColor(color);
        }
    }
}

