/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import java.util.ArrayList;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.event.OptionsSource;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.gui.edit.Effect;
import org.catacomb.druid.swing.DChoice;
import org.catacomb.druid.swing.DLabel;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.structure.Ablable;
import org.catacomb.interlish.structure.Choice;
import org.catacomb.interlish.structure.StringValueEditor;
import org.catacomb.interlish.structure.Updatable;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;
import org.catacomb.report.E;

public class DruChoice
extends DruGCPanel
implements LabelActor,
Ablable,
Choice,
StringValueEditor,
ValueWatcher {
    static final long serialVersionUID = 1001L;
    DLabel dLabel;
    DChoice dChoice;
    StringValue stringValue;
    ArrayList<Effect> effects;

    public DruChoice(String[] opts, String mnm) {
        this(null, opts, opts, mnm);
    }

    public DruChoice(String label, String mnm) {
        this(label, null, null, mnm);
    }

    public DruChoice(String label, String[] opts, String[] labs, String mnm) {
        this.setActionMethod(mnm);
        this.dChoice = new DChoice(opts, labs);
        if (label != null && label.length() > 0) {
            this.setBorderLayout(4, 4);
            this.dLabel = new DLabel(label);
            this.addDComponent(this.dLabel, "West");
            this.addDComponent(this.dChoice, "Center");
        } else {
            this.addSingleDComponent(this.dChoice);
        }
        this.setStringValue(new StringValue());
        this.dChoice.setLabelActor(this);
    }

    public void setEffects(ArrayList<Effect> arl) {
        this.effects = arl;
    }

    @Override
    public void setStringValue(StringValue bv) {
        if (this.stringValue != null) {
            this.stringValue.removeValueWatcher(this);
        }
        this.stringValue = bv;
        if (this.stringValue == null) {
            this.dChoice.setEnabled(false);
            this.applyState(null);
        } else {
            String s = this.stringValue.getString();
            this.dChoice.setSelected(s);
            this.applyState(s);
            this.dChoice.setEnabled(this.stringValue.isAble());
            this.stringValue.addValueWatcher(this);
        }
    }

    private void applyState(String s) {
        if (this.effects != null) {
            for (Effect eff : this.effects) {
                eff.apply(s);
            }
        }
    }

    @Override
    public void valueChangedBy(Value pv, Object src) {
        if (src == this) {
            this.valueChange(this.stringValue.getString());
        } else if (this.stringValue == pv) {
            if (this.stringValue == null) {
                this.able(false);
            } else {
                this.dChoice.setSelected(this.stringValue.getString());
                this.able(this.stringValue.isAble());
            }
        } else {
            E.error("value changed by called with mismatched value");
        }
    }

    @Override
    public void unselect() {
        this.stringValue.reportableSetString(null, this);
    }

    public void setUpdatable(Updatable u) {
        this.dChoice.setUpdatable(u);
    }

    public void setAutoSelect(int ias) {
        this.dChoice.setAutoSelect(ias);
    }

    public void setOptionsSource(OptionsSource os) {
        this.dChoice.setOptionsSource(os);
    }

    public void setSelected(String s) {
        this.dChoice.setSelected(s);
    }

    public String getSelected() {
        return this.dChoice.getSelected();
    }

    @Override
    public void setBg(Color c) {
        this.dChoice.setBg(c);
        super.setBg(c);
    }

    @Override
    public void able(boolean b) {
        this.dChoice.setEnabled(b);
        if (this.dLabel != null) {
            this.dLabel.setEnabled(b);
        }
    }

    public void setTooltip(String s) {
        this.dChoice.setTooltip(s);
    }

    @Override
    public void setOptions(String[] sa) {
        this.setOptions(sa, sa);
    }

    public void setOptions(String[] sa, String[] sl) {
        this.dChoice.setOptions(sa, sl);
    }

    public void updateOptions() {
        this.dChoice.checkOptions();
    }

    @Override
    public void labelAction(String s, boolean b) {
        this.applyState(s);
        if (this.stringValue != null) {
            this.stringValue.reportableSetString(this.dChoice.getSelected(), this);
        }
    }

    public void clearSelection() {
        this.dChoice.clearSelection();
    }
}

