/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.swing.DProgressReport;
import org.catacomb.interlish.structure.ProgressReport;

public class DruProgressReport
extends DruGCPanel
implements ProgressReport {
    static final long serialVersionUID = 1001L;
    DProgressReport dProgressReport = new DProgressReport();
    String text;
    double fraction;
    double fmin = 0.0;
    double fmax = 1.0;
    boolean indeterminate;

    public DruProgressReport() {
        this.addSingleDComponent(this.dProgressReport);
    }

    @Override
    public void setFocus(double min, double max) {
        this.fmin = min;
        this.fmax = max;
    }

    @Override
    public void setBg(Color c) {
        this.dProgressReport.setBg(c);
        super.setBg(c);
        this.setEtchedUpBorder(c);
    }

    @Override
    public void setIndeterminate(boolean b) {
        this.indeterminate = b;
    }

    @Override
    public void setStarted() {
        this.fraction = 0.0;
        this.update();
    }

    @Override
    public void setFraction(double f) {
        this.indeterminate = false;
        this.fraction = this.fmin + f * (this.fmax - this.fmin);
    }

    @Override
    public void setText(String txt) {
        this.text = txt;
        this.update();
    }

    @Override
    public double getFraction() {
        return this.fraction;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void update() {
        if (this.indeterminate) {
            this.dProgressReport.setIndeterminate(true);
        } else {
            this.dProgressReport.setIndeterminate(false);
            this.dProgressReport.setValue((int)(this.fraction * 200.0));
        }
        if (this.text != null) {
            this.dProgressReport.setString(this.text);
        } else {
            this.dProgressReport.setString("");
        }
    }

    @Override
    public void setFinished() {
        this.fraction = 1.0;
        this.update();
    }
}

