/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;

final class BoxSelectionHandler
extends MouseHandler {
    private boolean vtl;
    private boolean vtr;
    private boolean vbl;
    private boolean vbr;
    private int x0;
    private int y0;
    private int x1;
    private int y1;
    private int[] xyxy;
    static final int NORMAL = 0;
    static final int SIMPLE = 1;
    int actionMode;

    public BoxSelectionHandler() {
        this.clear();
        this.actionMode = 0;
        this.xyxy = new int[4];
        this.setRepaintStatus(0);
    }

    @Override
    public void activate() {
        this.actionMode = 0;
        super.activate();
    }

    public void simpleActivate() {
        this.activate();
        this.actionMode = 1;
    }

    @Override
    public void clear() {
        this.vtl = false;
        this.vtr = false;
        this.vbl = false;
        this.vbr = false;
    }

    @Override
    public void init(Mouse m) {
        this.clear();
        this.x0 = m.getX();
        this.y0 = m.getY();
        if (this.actionMode == 1) {
            this.setClaimIn();
        }
    }

    @Override
    public void advance(Mouse m) {
        if (this.isUndecided()) {
            this.checkActivate(m.getX(), m.getY());
        }
        this.setRepaintStatus(1);
    }

    @Override
    void echoPaint(Graphics2D g) {
        g.setColor(Color.red);
        g.drawLine(this.x0, this.y0, this.x1, this.y0);
        g.drawLine(this.x0, this.y0, this.x0, this.y1);
        g.drawLine(this.x1, this.y1, this.x1, this.y0);
        g.drawLine(this.x1, this.y1, this.x0, this.y1);
    }

    @Override
    public void applyOnDown(Mouse m) {
    }

    @Override
    public void applyOnDrag(Mouse m) {
        this.readPosition(m);
        this.setRepaintStatus(1);
    }

    @Override
    public void applyOnRelease(Mouse m) {
        this.readPosition(m);
        int xa = this.x0 < this.x1 ? this.x0 : this.x1;
        int ya = this.y0 < this.y1 ? this.y0 : this.y1;
        int xb = this.x0 < this.x1 ? this.x1 : this.x0;
        int yb = this.y0 < this.y1 ? this.y1 : this.y0;
        m.boxSelected(xa, ya, xb, yb);
    }

    void readPosition(Mouse m) {
        this.x1 = m.getX();
        this.y1 = m.getY();
    }

    public int[] getXYXY() {
        this.xyxy[0] = this.x0;
        this.xyxy[1] = this.y0;
        this.xyxy[2] = this.x1;
        this.xyxy[3] = this.y1;
        return this.xyxy;
    }

    private void checkActivate(int x, int y) {
        int thresh;
        int dx = x - this.x0;
        int dy = y - this.y0;
        int pt = thresh = 8;
        int mt = -1 * thresh;
        this.vtl = this.vtl || dx < mt && dy < mt;
        this.vtr = this.vtr || dx > pt && dy < mt;
        this.vbl = this.vbl || dx < mt && dy > pt;
        boolean bl = this.vbr = this.vbr || dx > pt && dy > pt;
        if (this.vtl && dx > 0 && dy > 0 || this.vtr && dx < 0 && dy > 0 || this.vbl && dx > 0 && dy < 0 || this.vbr && dx < 0 && dy < 0) {
            this.setClaimIn();
            this.x1 = x;
            this.y1 = y;
        }
    }
}

