/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import org.catacomb.datalish.SpriteAnimation;
import org.catacomb.graph.gui.BasePanel;
import org.catacomb.graph.gui.MovieFramePlayer;
import org.catacomb.graph.gui.MoviePaintInstructor;
import org.catacomb.graph.gui.PickWorldCanvas;
import org.catacomb.graph.gui.SpriteMoviePainter;
import org.catacomb.interlish.report.Logger;
import org.catacomb.interlish.structure.ModeSettable;
import org.catacomb.interlish.structure.MovieOperator;
import org.catacomb.interlish.structure.MovieStateDisplay;
import org.catacomb.movie.gif.AnimatedGifEncoder;
import org.catacomb.report.E;
import org.catacomb.util.AWTUtil;

public class MovieDisplay
extends BasePanel
implements ModeSettable,
MovieOperator {
    static final long serialVersionUID = 1001L;
    MoviePaintInstructor moviePaintInstructor;
    MovieStateDisplay movieStateDisplay;
    PickWorldCanvas pwCanvas;
    BasePanel controlPanel;
    Dimension prefDim;
    Color bgColor = Color.gray;
    double speed = 1.0;
    boolean isPaused = false;
    MovieFramePlayer movieFramePlayer;
    int nFrame;
    int shownFrame;

    public MovieDisplay(int w, int h) {
        this.prefDim = new Dimension(w, h);
        this.setPreferredSize(this.prefDim);
        this.pwCanvas = new PickWorldCanvas(w, h, true);
        this.pwCanvas.setOnGridAxes();
        this.pwCanvas.setFixedAspectRatio(1.0);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", this.pwCanvas);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefDim;
    }

    @Override
    public void setBg(Color c) {
        this.bgColor = c;
        this.pwCanvas.setBg(c);
    }

    @Override
    public void setMode(String dom, String mod) {
        this.pwCanvas.setMode(dom, mod);
    }

    @Override
    public void setMode(String dom, boolean b) {
        this.pwCanvas.setMode(dom, b);
    }

    public void setMovie(SpriteAnimation sanim) {
        this.setMoviePaintInstructor(new SpriteMoviePainter(sanim));
        this.nFrame = this.moviePaintInstructor.getNFrames();
        if (this.nFrame > 0) {
            this.showFrame(this.nFrame - 1);
        }
    }

    public void setMoviePaintInstructor(MoviePaintInstructor mpi) {
        this.moviePaintInstructor = mpi;
        this.pwCanvas.setPaintInstructor(mpi);
    }

    public void attach(Object obj) {
        boolean done = false;
        if (obj instanceof MoviePaintInstructor) {
            this.setMoviePaintInstructor((MoviePaintInstructor)obj);
            done = true;
        }
        if (!done) {
            E.error("cant attach " + obj + " to a data Display");
        }
    }

    public void setLimits(double[] xyxy) {
        this.pwCanvas.setXRange(xyxy[0], xyxy[2]);
        this.pwCanvas.setYRange(xyxy[1], xyxy[3]);
    }

    public void setXRange(double low, double high) {
        this.pwCanvas.setXRange(low, high);
    }

    public double[] getXRange() {
        return this.pwCanvas.getXRange();
    }

    public double[] getYRange() {
        return this.pwCanvas.getYRange();
    }

    public void setFixedAspectRatio(double ar) {
        this.pwCanvas.setFixedAspectRatio(ar);
    }

    public void viewChanged() {
        if (this.pwCanvas != null) {
            this.pwCanvas.repaint();
        }
    }

    public void reframe() {
        this.pwCanvas.reframe();
    }

    public void advanceToFrame(int ifr) {
        if (this.moviePaintInstructor != null) {
            this.moviePaintInstructor.advanceToFrame(ifr);
            this.shownFrame = ifr;
            this.displayFrame();
        }
    }

    @Override
    public void showFrame(int ifr) {
        if (this.moviePaintInstructor != null) {
            this.moviePaintInstructor.setFrame(ifr);
            this.shownFrame = ifr;
            this.displayFrame();
        }
    }

    private void displayFrame() {
        this.pwCanvas.repaint();
        this.nFrame = this.moviePaintInstructor.getNFrames();
        if (this.movieStateDisplay != null) {
            this.movieStateDisplay.frameChangedTo(this.shownFrame, this.moviePaintInstructor.getFrameDescription(this.shownFrame));
        }
    }

    @Override
    public int getNFrame() {
        return this.nFrame;
    }

    @Override
    public void reset() {
        this.stop();
        this.showFrame(0);
    }

    public void play() {
        this.stop();
        this.reset();
        this.start();
        this.dePause();
    }

    @Override
    public void resume() {
        this.dePause();
        this.start();
    }

    public void pause() {
        this.pauseDePause();
    }

    @Override
    public void pauseDePause() {
        if (this.isPaused) {
            this.dePause();
            this.start();
        } else {
            this.rePause();
            this.stop();
        }
    }

    public void dePause() {
        this.isPaused = false;
    }

    private void rePause() {
        this.isPaused = true;
    }

    @Override
    public void start() {
        this.nFrame = this.moviePaintInstructor.getNFrames();
        if (!this.canAdvance()) {
            this.reset();
        }
        if (this.nFrame > 0) {
            this.movieFramePlayer = new MovieFramePlayer(this);
            this.movieFramePlayer.start();
        }
    }

    @Override
    public void stop() {
        this.nFrame = this.moviePaintInstructor.getNFrames();
        if (this.movieFramePlayer != null) {
            this.movieFramePlayer.stop();
        }
    }

    @Override
    public void faster() {
        this.speed *= 1.3;
    }

    @Override
    public void slower() {
        this.speed /= 1.3;
    }

    public boolean canAdvance() {
        return this.shownFrame < this.nFrame - 1;
    }

    public void advance() {
        this.advanceToFrame(this.shownFrame + 1);
    }

    public double getSpeed() {
        return this.speed;
    }

    @Override
    public void setMovieStateDisplay(MovieStateDisplay msd) {
        this.movieStateDisplay = msd;
    }

    public void reluctantReframe() {
        this.pwCanvas.reluctantReframe();
    }

    public BufferedImage getBufferedImage(int ithick) {
        BufferedImage ret = AWTUtil.getBufferedImage(this);
        return ret;
    }

    @Override
    public void record(File f, Logger l) {
        this.stop();
        this.reset();
        MDThreadRunner mdtr = new MDThreadRunner(this, f, l);
        Thread thr = new Thread(mdtr);
        thr.setPriority(1);
        thr.start();
        l.init("writing animated gif " + f);
    }

    protected void threadRecord(File f, Logger l) {
        int delay = (int)(20.0 / this.speed);
        AnimatedGifEncoder enc = new AnimatedGifEncoder();
        enc.start(f);
        enc.setDelay(delay);
        int ifr = 0;
        E.info("animated gif - frame " + ifr);
        enc.addFrame(this.getBufferedImage(1));
        while (this.canAdvance()) {
            this.advance();
            E.info("frame " + ++ifr);
            l.optionalIncrementLog(ifr, "frame");
            enc.addFrame(this.getBufferedImage(1));
        }
        enc.finish();
        l.end();
    }

    class MDThreadRunner
    implements Runnable {
        File file;
        Logger logger;
        MovieDisplay movdisplay;

        MDThreadRunner(MovieDisplay md, File f, Logger l) {
            this.movdisplay = md;
            this.file = f;
            this.logger = l;
        }

        @Override
        public void run() {
            this.movdisplay.threadRecord(this.file, this.logger);
        }
    }
}

