/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.reflect;

import org.catacomb.be.ReReferencable;
import org.catacomb.interlish.service.ContentLoader;
import org.catacomb.interlish.service.ResourceAccess;
import org.catacomb.interlish.structure.Attribute;
import org.catacomb.interlish.structure.BodyValued;
import org.catacomb.interlish.structure.Constructor;
import org.catacomb.interlish.structure.Element;
import org.catacomb.interlish.structure.ElementReader;
import org.catacomb.interlish.structure.Factory;
import org.catacomb.report.E;

public class ObjectBuilder {
    Constructor instantiator;
    static final int UNKNOWN = 0;
    static final int CLASS = 1;
    static final int FACTORY = 2;
    static final int PROVIDER = 3;
    ContentLoader contentLoader;
    Object wkObject;
    String wkID;
    Element workElt;

    public ObjectBuilder(Constructor inst) {
        this.instantiator = inst;
        if (ResourceAccess.hasContentLoader()) {
            this.contentLoader = ResourceAccess.getContentLoader();
        }
    }

    public Object buildFromElement(Element elt) {
        this.workElt = elt;
        Object ret = null;
        if (elt.hasAttribute("id")) {
            this.wkID = elt.getAttribute("id");
        }
        int mode = 0;
        if (this.contentLoader == null || elt.hasAttribute("class") || elt.hasAttribute("package")) {
            mode = 1;
        } else if (this.contentLoader.hasFactoryFor(elt.getName())) {
            mode = 2;
        } else if (this.contentLoader.hasProviderOf(elt.getName())) {
            mode = 3;
        }
        if (mode == 1) {
            ret = this.refBuildFromElement(null, elt);
        } else if (mode == 2) {
            Factory ospec = this.contentLoader.getFactoryFor(elt.getName());
            Factory fac = ospec;
            if (fac == null) {
                E.error(" - loader returned null factory for " + elt.getName());
            } else {
                this.wkObject = ret = fac.make(elt.getName());
                fac.populate(ret, elt);
                if (ret instanceof ReReferencable) {
                    ((ReReferencable)ret).reReference();
                }
            }
        } else if (mode == 3) {
            this.wkObject = ret = this.contentLoader.getProviderOf(elt.getName());
            this.populate(ret, elt);
        } else {
            E.error("dont know what to do with element (no class, factory or provider) " + elt);
        }
        return ret;
    }

    private String simpleContentSerialization(Element elt) {
        StringBuffer sb = new StringBuffer();
        this.appendContent(elt, sb);
        return sb.toString();
    }

    private void appendContent(Element topelt, StringBuffer sb) {
        if (topelt.getText() != null) {
            sb.append(topelt.getText());
        }
        if (topelt.hasElements()) {
            for (Element elt : topelt.getElements()) {
                if (elt.hasAttributes()) {
                    sb.append("\n<" + elt.getName());
                    for (Attribute att : elt.getAttributes()) {
                        sb.append(" " + att.getName() + "=\"" + att.getValue() + "\"");
                    }
                    sb.append(">");
                } else {
                    sb.append("<" + elt.getName() + ">");
                }
                this.appendContent(elt, sb);
                sb.append("</" + elt.getName() + ">\n");
            }
        }
    }

    public Object refBuildFromElement(Object parent, Element elt) {
        String[] ret = null;
        ret = this.instantiator.getChildObject(parent, elt.getName(), elt.getAttributeArray());
        if (ret instanceof String) {
            ret = this.simpleContentSerialization(elt);
        } else if (ret instanceof String[]) {
            ret = this.readStringArray(elt);
        } else {
            this.populate(ret, elt);
        }
        return ret;
    }

    private String[] readStringArray(Element elt) {
        Element[] ea = elt.getElementArray();
        String[] ret = null;
        if (ea == null) {
            ret = new String[]{};
        } else {
            ret = new String[ea.length];
            int i = 0;
            while (i < ea.length) {
                Element sub = ea[i];
                if (sub.getName().equals("item")) {
                    ret[i] = sub.getAttribute("value");
                } else {
                    E.warning("wrong element type in a string array " + sub);
                }
                ++i;
            }
        }
        return ret;
    }

    public void populate(Object target, Element elt) {
        if (target instanceof ElementReader) {
            ((ElementReader)target).populateFrom(elt);
        } else {
            if (elt.hasAttributes()) {
                for (Attribute att : elt.getAttributes()) {
                    if (att.getName().equals("archive-hash")) {
                        E.deprecate();
                        continue;
                    }
                    this.instantiator.setAttributeField(target, att.getName(), att.getValue());
                }
            }
            if (elt.hasElements()) {
                for (Element childelt : elt.getElements()) {
                    Object child = this.refBuildFromElement(target, childelt);
                    if (child == null) {
                        E.error("got null object from element " + childelt + " " + target.getClass().getName());
                        continue;
                    }
                    this.instantiator.setField(target, childelt.getName(), child);
                }
            }
            if (elt.hasText()) {
                if (target instanceof BodyValued) {
                    ((BodyValued)target).setBody(elt.getText());
                } else {
                    String ss = elt.serialize();
                    int idis = ss.indexOf("//DISABLED");
                    if (idis < 0 || idis >= 50) {
                        E.linkToWarning("nowhere to put body text: in (" + target.getClass().getName() + ") may relate to " + this.wkID + " " + this.wkObject, target);
                    }
                }
            }
        }
        if (target instanceof ReReferencable) {
            ((ReReferencable)target).reReference();
        }
    }
}

