/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet;

import org.catacomb.report.E;

public class CellPoint {
    public int activeType;
    public int geometricalType;
    public double x;
    public double y;
    public double z;
    public double r;
    public CellPoint[] nbr = new CellPoint[6];
    public int nnbr = 0;
    public int index;
    public int parentIndex;
    public int iwork;
    public boolean umark = false;
    public boolean wmark = false;
    public boolean dead = false;
    public int wcount;
    public double dgx;
    public double dgy;
    public String name;

    public CellPoint() {
    }

    public CellPoint(double x, double y, double z, double r, int gtype, int atype) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.geometricalType = gtype < 0 ? 0 : gtype;
        this.activeType = atype < 0 ? 0 : atype;
    }

    public CellPoint makeCopy() {
        return new CellPoint(this.x, this.y, this.z, this.r, this.geometricalType, this.activeType);
    }

    public void setWork(int iw) {
        this.iwork = iw;
    }

    public int getWork() {
        return this.iwork;
    }

    public String toString() {
        return "zyzr: " + this.x + " " + this.y + " " + this.z + " " + this.r + " nnbr=" + this.nnbr;
    }

    public void setPosition(double[] a) {
        this.x = a[0];
        this.y = a[1];
        this.z = a[2];
        if (a.length >= 3) {
            this.r = a[3];
        }
    }

    public void locateBetween(CellPoint cpa, CellPoint cpb, double f) {
        double wf = 1.0 - f;
        this.x = f * cpb.x + wf * cpa.x;
        this.y = f * cpb.y + wf * cpa.y;
        this.z = f * cpb.z + wf * cpa.z;
        this.r = f * cpb.r + wf * cpa.r;
    }

    public void addNeighbor(CellPoint cpn) {
        if (this.nnbr >= this.nbr.length) {
            CellPoint[] pn = new CellPoint[2 * this.nnbr];
            int i = 0;
            while (i < this.nnbr) {
                pn[i] = this.nbr[i];
                ++i;
            }
            this.nbr = pn;
        }
        this.nbr[this.nnbr++] = cpn;
    }

    public void removeNeighbor(CellPoint cp) {
        int ii = -1;
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbr[i] == cp) {
                ii = i;
            }
            ++i;
        }
        if (ii >= 0) {
            i = ii;
            while (i < this.nnbr - 1) {
                this.nbr[i] = this.nbr[i + 1];
                ++i;
            }
            --this.nnbr;
        }
    }

    public void replaceNeighbor(CellPoint cp, CellPoint cr) {
        int ii = -1;
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbr[i] == cp) {
                ii = i;
            }
            ++i;
        }
        if (ii >= 0) {
            this.nbr[ii] = cr;
        } else {
            E.error(" (replaceNeighbor) couldnt find nbr " + cp + " in nbrs list of " + this);
        }
    }

    public boolean hasNeighbor(CellPoint cp) {
        boolean hn = false;
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbr[i] == cp) {
                hn = true;
            }
            ++i;
        }
        return hn;
    }

    public void removeDeadNeighbors() {
        int i = this.nnbr - 1;
        while (i >= 0) {
            if (this.nbr[i].dead) {
                this.removeNeighbor(this.nbr[i]);
            }
            --i;
        }
    }

    public double distanceTo(CellPoint cp) {
        double dx = this.x - cp.x;
        double dy = this.y - cp.y;
        double dz = this.z - cp.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void movePerp(CellPoint ca, CellPoint cb, double dperp) {
        double dx = cb.x - ca.x;
        double dy = cb.y - ca.y;
        double f = Math.sqrt(dx * dx + dy * dy);
        this.x += dperp * (dy /= f);
        this.y -= dperp * (dx /= f);
    }
}

