/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.function;

import org.catacomb.numeric.math.Random;

public final class AR1Noise {
    double regression;
    double amplitude = 1.0;
    double mean = 0.0;
    double x;
    double fnew;

    public AR1Noise() {
        this.setRegression(0.95);
    }

    public void setRegression(double d) {
        this.regression = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        this.fnew = Math.sqrt(1.0 - this.regression * this.regression);
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public void setMean(double d) {
        this.mean = d;
    }

    public double nextValue() {
        this.x = this.regression * this.x + this.fnew * this.amplitude * Random.gaussianRV();
        return this.mean + this.x;
    }

    public static double nextValue(double cvalue, double amp, double reg) {
        double ff = Math.sqrt(1.0 - reg * reg);
        double ret = reg * cvalue + ff * amp * Random.gaussianRV();
        return ret;
    }
}

