/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial.quickxml;

import org.catacomb.report.E;

public class Element {
    String name;
    String value;
    Element[] elements;
    boolean free;

    public Element(String s) {
        this.name = s;
        this.elements = new Element[0];
        this.free = false;
    }

    public Element(String s, String sv) {
        this.name = s;
        this.elements = new Element[0];
        this.setValue(sv);
        this.free = false;
    }

    public void setFree() {
        this.free = true;
    }

    public boolean isFree() {
        return this.free;
    }

    public void setValue(String txtin) {
        String txt = txtin;
        this.clear();
        this.value = "";
        if (txt != null) {
            if ((txt = txt.trim()).startsWith("<")) {
                this.addElementsFrom(txt);
            } else {
                this.value = txt;
            }
        }
    }

    public void addElementsFrom(String txtin) {
        String txt = txtin;
        if ((txt = txt.trim()).length() > 0) {
            if (txt.startsWith("<")) {
                int ic = (txt = txt.substring(1)).indexOf(">");
                if (ic <= 0) {
                    E.error(" parsing element (no closing bracket) " + txt);
                } else {
                    String sclo;
                    String enm = txt.substring(0, ic);
                    int iclo = (txt = txt.substring(ic + 1)).indexOf(sclo = "</" + enm + ">");
                    if (iclo >= 0) {
                        String ev = txt.substring(0, iclo);
                        this.addElement(enm, ev);
                        txt = txt.substring(iclo + sclo.length());
                        this.addElementsFrom(txt);
                    }
                }
            } else {
                E.error(" - Element adding sublets needs < but got " + txt);
            }
        }
    }

    public void set(String eltname, String val) {
        Element elt = this.getElement(eltname);
        if (elt == null) {
            E.error(" - no element " + eltname + "in " + this);
        } else {
            elt.setValue(val);
        }
    }

    public void set(String e1name, String e2name, String val) {
        this.getElement(e1name).set(e2name, val);
    }

    public void setSubelements(String enm, String[] vs) {
        this.clear();
        this.elements = new Element[vs.length];
        int i = 0;
        while (i < vs.length) {
            this.elements[i] = new Element(enm);
            this.elements[i].setValue(vs[i]);
            ++i;
        }
    }

    public void clear() {
        this.elements = new Element[0];
    }

    public String get() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String get(String s) {
        String ret = null;
        Element elt = this.getElement(s);
        if (elt != null) {
            ret = elt.get();
        }
        return ret;
    }

    public String get(String s1, String s2) {
        Element elt1 = this.getElement(s1);
        Element elt2 = elt1.getElement(s2);
        return elt2.get();
    }

    public String[] getAll(String s1, String s2) {
        Element elt1 = this.getElement(s1);
        return elt1.getAll(s2);
    }

    public String[] getValues(String s) {
        return this.getAll(s);
    }

    public String[] getAll(String s) {
        int nr = 0;
        String[] retp = new String[this.elements.length];
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].getName().equals(s)) {
                retp[nr++] = this.elements[i].get();
            }
            ++i;
        }
        String[] ret = new String[nr];
        int i2 = 0;
        while (i2 < nr) {
            ret[i2] = retp[i2];
            ++i2;
        }
        return ret;
    }

    public boolean hasElement(String s, String v) {
        boolean ret = false;
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].getName().equals(s) && this.elements[i].get().equals(v)) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    public boolean hasElement(String eltname) {
        boolean ret = false;
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].getName().equals(eltname)) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    public String getValue(String lname) {
        return this.get(lname);
    }

    public Element[] getElements() {
        return this.elements;
    }

    public void limitNumber(String eltname, int nmax) {
        String[] sv = this.getAll(eltname);
        int nel = sv.length;
        int ntg = nel - nmax;
        if (ntg > 0) {
            Element[] ael = this.getElements();
            int nlst = ael.length;
            while (ntg > 0) {
                if (!ael[--nlst].getName().equals(eltname)) continue;
                --ntg;
                this.removeElement(nlst);
            }
        }
    }

    public void removeAll(String eltname) {
        Element[] ael = this.getElements();
        int i = ael.length - 1;
        while (i >= 0) {
            if (ael[i].getName().equals(eltname)) {
                this.removeElement(i);
            }
            --i;
        }
    }

    public void add(Element elt) {
        this.addElement(elt);
    }

    public void add(String eltname) {
        this.addElement(new Element(eltname));
    }

    public void addElement(String eltname, String ev) {
        this.addElement(new Element(eltname, ev));
    }

    public void addElement(String en1, String en2, String ev) {
        this.getElement(en1).addElement(new Element(en2, ev));
    }

    public void prependElementUnique(String eltname, String ev) {
        if (ev == null || ev.length() == 0) {
            return;
        }
        String[] sv = this.getValues(eltname);
        boolean got = false;
        int itg = -1;
        if (sv != null) {
            int i = 0;
            while (i < sv.length) {
                if (ev.equals(sv[i])) {
                    got = true;
                    itg = i;
                }
                ++i;
            }
        }
        if (got) {
            this.removeElement(itg);
        }
        this.prependElement(eltname, ev);
    }

    public void prependElement(String eltname, String ev) {
        this.prependElement(new Element(eltname, ev));
    }

    public void addElement(Element elt) {
        int n = this.elements.length;
        Element[] en = new Element[n + 1];
        int i = 0;
        while (i < n) {
            en[i] = this.elements[i];
            ++i;
        }
        en[n] = elt;
        this.elements = en;
    }

    public void removeElement(int itg) {
        int n = this.elements.length;
        Element[] en = new Element[n - 1];
        int i = 0;
        while (i < itg) {
            en[i] = this.elements[i];
            ++i;
        }
        i = itg;
        while (i < n - 1) {
            en[i] = this.elements[i + 1];
            ++i;
        }
        this.elements = en;
    }

    public void setElement(String name, String value) {
        this.removeAll(name);
        this.addElement(name, value);
    }

    public void prependElement(Element elt) {
        int n = this.elements.length;
        Element[] en = new Element[n + 1];
        int i = 0;
        while (i < n) {
            en[i + 1] = this.elements[i];
            ++i;
        }
        en[0] = elt;
        this.elements = en;
    }

    public void randomFill() {
        if (this.elements.length > 0) {
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].randomFill();
                ++i;
            }
        } else {
            this.value = "" + Math.random();
        }
    }

    public Element getElement(String sn) {
        Element ret = null;
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].getName().equals(sn)) {
                ret = this.elements[i];
            }
            ++i;
        }
        return ret;
    }

    public void populateFrom(String srcin) {
        int ic;
        String src = srcin;
        Element elt = this;
        String enm = elt.getName();
        String otag = "<" + enm + ">";
        String ctag = "</" + enm + ">";
        int io = src.indexOf(otag);
        if (io >= 0 && (ic = (src = src.substring(io + otag.length(), src.length())).indexOf(ctag)) > 0) {
            src = src.substring(0, ic);
            Element[] ea = elt.getElements();
            if (!elt.isFree() && ea != null && ea.length > 0) {
                int i = 0;
                while (i < ea.length) {
                    ea[i].populateFrom(src);
                    ++i;
                }
            } else {
                elt.setValue(src);
            }
        }
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        this.appendTo(sb, "");
        return sb.toString();
    }

    private void appendTo(StringBuffer sb, String indent) {
        sb.append(String.valueOf(indent) + "<" + this.name + ">");
        int nel = this.elements.length;
        if (nel > 0) {
            sb.append("\n");
            int i = 0;
            while (i < nel) {
                this.elements[i].appendTo(sb, String.valueOf(indent) + "   ");
                ++i;
            }
            sb.append(indent);
        } else {
            String sv = this.value;
            if (sv == null) {
                sv = "";
            }
            sv = sv.trim();
            sb.append(sv);
        }
        sb.append("</" + this.name + ">\n");
        if (nel > 0) {
            sb.append("\n");
        }
    }
}

