/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.xdoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.catacomb.report.E;
import org.catacomb.util.FileUtil;

public class TextTagger {
    static String[][] legalizers = new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {"'", "&apos;"}, {"\"", "&quot;"}};
    static String[][] linkizers = new String[][]{{"((\\s)(http://[\\w\\.]*)(\\s))", " <ain href=\"$3\">$3</ain> "}, {"((\\s)(\\w+\\.\\w+\\.\\w+)(\\s))", " <ain href=\"http://$3\">$3</ain> "}, {"(\\{(.+?)\\|(.+?)\\})", " <ain href=\"$3\">$2</ain> "}, {"(?m)^file: *(.+) *$", "file: <ai href\"($1)\">$1</ai><br/>\\\n"}, {" #(\\d*)", " <CR>$1</CR>"}};
    static String[][] emphasizers = new String[][]{{"((\\s_)([\\w\\s]+)_([\\s\\p{Punct}]))", " <u>$3</u>$4"}, {"((\\s\\*)([\\w\\s]+)\\*([\\s\\p{Punct}]))", " <b>$3</b>$4"}, {"((\\s/)([\\w\\s]+)/([\\s\\p{Punct}]))", " <i>$3</i>$4"}};
    static String[][] headerizers = new String[][]{{"^H:(.*)$", "\\\n\\\n<h2>$1</h2>\\\n\\\n "}, {"^H1:(.*)$", "\\\n\\\n<h1>$1</h1>\\\n\\\n"}, {"^H2:(.*)$", "\\\n\\\n<h2>$1</h2>\\\n\\\n"}, {"^H3:(.*)$", "\\\n\\\n<h3>$1</h3>\\\n\\\n"}, {"^H4:(.*)$", "\\\n\\\n<h4>$1</h4>\\\n\\\n"}};
    static String[][] elementizers = new String[][]{{"(^(\\w+?): *(.*?) *$)", "<element name=\"$2\" value=\"$3\"/>\n"}};
    static String paragraphSeparator = "(?<=(\r\n|\r|\n))([ \\t]*$)+";
    static String paragraphMatch = "(^.*\\S+.*$)+";
    static String listItemPrefix = " *[+*-] +";
    static String attributeLine = "(^(\\w+?) *= *(.*?) *$)";
    static String elementTag = "^(\\w+?):";
    static TextTagger tagger;

    public static TextTagger getTagger() {
        if (tagger == null) {
            tagger = new TextTagger();
        }
        return tagger;
    }

    public void init() {
    }

    public String textToXML(String plainText, String defaultRoot) {
        String xtxt = plainText;
        xtxt = this.legalize(xtxt);
        String[] wrapper = new String[2];
        xtxt = this.extractAttributes(xtxt, defaultRoot, wrapper);
        xtxt = this.headerize(xtxt);
        xtxt = this.elementize(xtxt);
        xtxt = this.listize(xtxt);
        xtxt = this.paragraphize(xtxt);
        xtxt = this.linkize(xtxt);
        xtxt = this.emphasize(xtxt);
        xtxt = this.xmlwrap(xtxt, wrapper);
        return xtxt;
    }

    public String tagText(String plainText) {
        String xtxt = plainText;
        xtxt = xtxt.replaceAll("-p-", "\n\n");
        xtxt = this.legalize(xtxt);
        xtxt = this.headerize(xtxt);
        xtxt = this.listize(xtxt);
        xtxt = this.paragraphize(xtxt);
        xtxt = this.linkize(xtxt);
        xtxt = this.emphasize(xtxt);
        return xtxt;
    }

    public String textToEdit(String plainText, String defaultRoot) {
        String xtxt = plainText;
        String fullxml = this.textToXML(plainText, defaultRoot);
        xtxt = this.legalize(xtxt);
        String[] wrapper = new String[2];
        xtxt = this.extractAttributesAsElements(xtxt, "source", wrapper);
        xtxt = this.preWrap(xtxt);
        xtxt = this.xmlwrap(xtxt, wrapper);
        StringBuffer sb = new StringBuffer();
        sb.append("<editsource>\n");
        sb.append(xtxt);
        sb.append("\n");
        sb.append("   <output>\n");
        sb.append(fullxml);
        sb.append("\n");
        sb.append("   </output>\n");
        sb.append("</editsource>\n");
        return sb.toString();
    }

    public void textToXML(File ftxt, File fxml) {
        String txt = FileUtil.readStringFromFile(ftxt);
        String xtxt = this.textToXML(txt, "default");
        FileUtil.writeStringToFile(xtxt, fxml);
    }

    public void textToEdit(File ftxt, File fedt) {
        String txt = FileUtil.readStringFromFile(ftxt);
        String etxt = this.textToEdit(txt, "default");
        FileUtil.writeStringToFile(etxt, fedt);
    }

    public String applyReplacements(String txtin, String[][] reps) {
        String txt = txtin;
        int i = 0;
        while (i < reps.length) {
            String[] lp = reps[i];
            txt = txt.replaceAll(lp[0], lp[1]);
            ++i;
        }
        return txt;
    }

    public String applyReplacementsMultiline(String txtin, String[][] reps) {
        String txt = txtin;
        int i = 0;
        while (i < reps.length) {
            String output;
            String[] lp = reps[i];
            Pattern pattern = Pattern.compile(lp[0], 8);
            Matcher matcher = pattern.matcher(txt);
            txt = output = matcher.replaceAll(lp[1]);
            ++i;
        }
        return txt;
    }

    public String legalize(String txt) {
        return this.applyReplacements(txt, legalizers);
    }

    public String linkize(String txt) {
        return this.applyReplacements(txt, linkizers);
    }

    public String emphasize(String txt) {
        return this.applyReplacements(txt, emphasizers);
    }

    public String headerize(String txt) {
        return this.applyReplacementsMultiline(txt, headerizers);
    }

    public String elementize(String txt) {
        return this.elementize2(txt);
    }

    public String htmlizeParagraph(String apar) {
        String stmp = this.legalize(apar);
        String ret = this.emphasize(stmp);
        return ret;
    }

    public String elementize2(String txt) {
        Pattern pat = Pattern.compile(elementTag);
        Matcher matcher = pat.matcher("");
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader sr = new BufferedReader(new StringReader(txt));
            while (sr.ready()) {
                String line = sr.readLine();
                if (line != null) {
                    matcher.reset(line);
                    if (matcher.find() && matcher.start() == 0) {
                        String tag = matcher.group(1);
                        sb.append(this.makeElement(tag, line));
                        sb.append("\n");
                        continue;
                    }
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            E.error("io exception listizing ");
            ex.printStackTrace();
        }
        return sb.toString();
    }

    private String makeElement(String tag, String line) {
        String ret = "";
        if (line.startsWith(String.valueOf(tag) + ":")) {
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(tag);
            String rest = line.substring(tag.length() + 1, line.length());
            StringTokenizer st = new StringTokenizer(rest, ",");
            boolean doneclose = false;
            while (st.hasMoreTokens()) {
                String stok = st.nextToken();
                if (doneclose) {
                    sb.append(stok);
                    continue;
                }
                int ieq = stok.indexOf("=");
                if (ieq > 0) {
                    String nm = stok.substring(0, ieq);
                    String val = stok.substring(ieq + 1, stok.length());
                    nm = nm.trim();
                    nm = nm.replaceAll(" ", "_");
                    sb.append(" ");
                    sb.append(nm);
                    sb.append("=\"");
                    val = val.trim();
                    sb.append(val);
                    sb.append("\"");
                    continue;
                }
                sb.append(">");
                sb.append(stok);
                doneclose = true;
            }
            if (!doneclose) {
                sb.append(">");
            }
            sb.append("</");
            sb.append(tag);
            sb.append(">\n");
            ret = sb.toString();
        } else {
            E.error(" misinterpreted element? ---" + tag + "---  ---" + line);
        }
        return ret;
    }

    public String paragraphize(String s) {
        return this.paragraphize1(s);
    }

    public String paragraphize1(String sin) {
        String s = sin;
        s = s.replaceAll("-p-", "\n\n");
        String[] paras = Pattern.compile(paragraphSeparator, 8).split(s);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < paras.length) {
            String par = paras[i];
            par = par.trim();
            this.insertParagraph(sb, par);
            ++i;
        }
        return sb.toString();
    }

    public String paragraphize2(String s) {
        Pattern pattern = Pattern.compile(paragraphMatch, 8);
        Matcher matcher = pattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String para = matcher.group();
            para = para.trim();
            this.insertParagraph(sb, para);
        }
        return sb.toString();
    }

    void insertParagraph(StringBuffer sb, String para) {
        if (para.length() > 0) {
            if (para.indexOf("<") < 0) {
                sb.append("\n<p>\n");
                sb.append(para);
                sb.append("\n</p>\n\n");
            } else {
                sb.append(para);
                sb.append("\n");
            }
        }
    }

    public String listize(String txt) {
        Pattern pat = Pattern.compile(listItemPrefix);
        Matcher matcher = pat.matcher("");
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader sr = new BufferedReader(new StringReader(txt));
            while (sr.ready()) {
                String line = sr.readLine();
                if (line != null) {
                    matcher.reset(line);
                    if (matcher.find() && matcher.start() == 0) {
                        String itemintro = matcher.group();
                        this.wrapList(sr, sb, itemintro, line);
                        continue;
                    }
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            E.error("io exception listizing ");
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public void wrapList(BufferedReader sr, StringBuffer sb, String itemintro, String fl) throws IOException {
        String firstline = fl;
        String itemcont = itemintro.replaceFirst("\\S", " ");
        boolean inli = false;
        boolean inul = false;
        sb.append("\n\n<ul>\n");
        inul = true;
        sb.append("  <li>\n");
        inli = true;
        firstline = firstline.substring(itemintro.length(), firstline.length());
        sb.append(firstline);
        sb.append("\n");
        String line = "";
        while (sr.ready()) {
            line = sr.readLine();
            if (line == null) break;
            if (line.trim().length() == 0) continue;
            if (line.startsWith(itemcont)) {
                sb.append(line);
                sb.append("\n");
                line = null;
                continue;
            }
            if (!line.startsWith(itemintro)) break;
            if (inli) {
                sb.append("   </li>\n");
            }
            line = line.substring(itemintro.length(), line.length());
            sb.append("   <li>\n");
            sb.append(line);
            sb.append("\n");
            line = null;
        }
        if (inli) {
            sb.append("</li>\n");
        }
        if (inul) {
            sb.append("</ul>\n\n");
        }
        if (line != null) {
            sb.append("\n\n");
            sb.append(line);
            sb.append("\n");
        }
    }

    String xmlwrap(String xtxt, String[] wrapper) {
        StringBuffer sb = new StringBuffer();
        sb.append(wrapper[0]);
        sb.append("\n");
        sb.append(xtxt);
        sb.append("\n");
        sb.append(wrapper[1]);
        sb.append("\n");
        return sb.toString();
    }

    String preWrap(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append("<pre>\n");
        sb.append(s);
        sb.append("\n");
        sb.append("</pre>\n");
        return sb.toString();
    }

    String htmlWrap(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n");
        sb.append("<head></head>\n");
        sb.append("<body>\n");
        sb.append(s);
        sb.append("\n");
        sb.append("</body>\n");
        return sb.toString();
    }

    String readAttributes(String xtxtin, String[][] sat) {
        String xtxt = xtxtin;
        Pattern pattern = Pattern.compile(attributeLine, 8);
        int nat = 0;
        Matcher matcher = pattern.matcher("");
        while (true) {
            xtxt = xtxt.trim();
            matcher.reset(xtxt);
            if (xtxt.length() <= 0 || !matcher.find() || matcher.start() != 0) break;
            String group = matcher.group();
            xtxt = xtxt.substring(group.length(), xtxt.length());
            String name = matcher.group(2);
            String value = matcher.group(3).trim();
            if (this.containsAttribute(sat, nat, name)) {
                E.warning(" ignoringdubplicate attribute " + name + " " + value);
                continue;
            }
            sat[nat][0] = name;
            sat[nat][1] = value;
            ++nat;
        }
        return xtxt;
    }

    private boolean containsAttribute(String[][] sat, int nat, String name) {
        boolean contains = false;
        int i = 0;
        while (i < nat) {
            if (sat[i][0].equals(name)) {
                contains = true;
                break;
            }
            ++i;
        }
        return contains;
    }

    String extractAttributes(String xtxtin, String defaultRoot, String[] wrapper) {
        String xtxt = xtxtin;
        String[][] sat = new String[100][2];
        xtxt = this.readAttributes(xtxt, sat);
        StringBuffer sb = new StringBuffer();
        String eltname = defaultRoot;
        if (eltname == null) {
            eltname = "default";
        }
        int i = 0;
        while (i < sat.length && sat[i][0] != null) {
            if (sat[i][0].equals("type")) {
                eltname = sat[i][1].replaceAll("\\s", "_");
            } else {
                sb.append("\n      ");
                sb.append(sat[i][0]);
                sb.append("=\"");
                sb.append(sat[i][1]);
                sb.append("\"");
            }
            ++i;
        }
        wrapper[0] = "<" + eltname + " src=\"txt\"" + sb.toString() + ">";
        wrapper[1] = "</" + eltname + ">";
        return xtxt;
    }

    public String extractAttributesAsElements(String xtxtin, String defaultRoot, String[] wrapper) {
        String[][] sat = new String[100][2];
        String xtxt = this.readAttributes(xtxtin, sat);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < sat.length && sat[i][0] != null) {
            sb.append("   <attribute name=\"");
            sb.append(sat[i][0]);
            sb.append("\" value=\"");
            sb.append(sat[i][1]);
            sb.append("\"/>\n");
            ++i;
        }
        wrapper[0] = "<" + defaultRoot + ">\n" + sb.toString();
        wrapper[1] = "</" + defaultRoot + ">";
        return xtxt;
    }

    public static void main(String[] argv) {
        TextTagger tt = new TextTagger();
        String sd = argv[0];
        File fdir = new File(sd);
        File[] af = fdir.listFiles();
        int i = 0;
        while (i < af.length) {
            String fnm = af[i].getName();
            if (fnm.endsWith(".txt")) {
                File ftxt = af[i];
                String sr = ftxt.getName();
                sr = sr.substring(0, sr.length() - 4);
                File fedt = new File(fdir, String.valueOf(sr) + ".edt");
                tt.textToEdit(ftxt, fedt);
                File fxml = new File(fdir, String.valueOf(sr) + ".xml");
                tt.textToXML(ftxt, fxml);
            }
            ++i;
        }
    }
}

