/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff;

import org.textensor.report.E;
import org.textensor.stochdiff.ResultWriter;
import org.textensor.stochdiff.SDCalcType;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.BaseCalc;

public class SDCalc {
    SDCalcType calculationType;
    SDRun sdRun;
    ResultWriter resultWriter;
    BaseCalc bCalc;

    public SDCalc(SDRun sdr) {
        this.sdRun = sdr;
        String sr = this.sdRun.calculation;
        SDCalcType[] sDCalcTypeArray = SDCalcType.values();
        int n = sDCalcTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SDCalcType sdct = sDCalcTypeArray[n2];
            if (sdct.hasLabel(sr)) {
                this.calculationType = sdct;
            }
            ++n2;
        }
        if (this.calculationType == null) {
            E.warning("unrecognized calculation type " + sr);
        }
    }

    public void setResultWriter(ResultWriter rw) {
        this.resultWriter = rw;
    }

    public void run() {
        this.bCalc = this.calculationType.getCalc(this.sdRun);
        if (this.resultWriter != null) {
            this.bCalc.setResultWriter(this.resultWriter);
        }
        this.bCalc.run();
        if (this.resultWriter != null) {
            this.resultWriter.close();
        }
    }

    public long getParticleCount() {
        return this.bCalc.getParticleCount();
    }
}

