/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff;

import org.textensor.report.E;
import org.textensor.stochdiff.numeric.math.MersenneTwister;
import org.textensor.stochdiff.numeric.stochastic.StepGenerator;

public class StepgenTests {
    public static void main(String[] argv) {
        StepgenTests.runtests();
    }

    public static void runtests() {
        int nsp = 0;
        int nrp = 0;
        MersenneTwister random = new MersenneTwister(12345L);
        int ntrials = 100000;
        int ntot = 1000;
        double[] means = new double[]{1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 0.9, 1.1, 3.0, 10.0};
        int j = 0;
        while (j < means.length) {
            nsp = 0;
            nrp = 0;
            double p = 0.999 * means[j] / (double)ntot;
            int i = 0;
            while (i < ntrials) {
                nrp += random.poisson(means[j]);
                nsp += StepGenerator.gaussianStep(ntot, p, random.gaussian(), random.random());
                ++i;
            }
            E.info("nevents mean=" + means[j] + " expect=" + (double)ntrials * means[j] + " " + nrp + " " + nsp);
            ++j;
        }
    }
}

