/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.inter.AddableTo;
import org.textensor.stochdiff.inter.FloatValued;
import org.textensor.stochdiff.model.Concentration;
import org.textensor.stochdiff.model.ConcentrationSet;
import org.textensor.stochdiff.model.FitConstraints;
import org.textensor.stochdiff.model.SurfaceDensity;
import org.textensor.stochdiff.model.SurfaceDensitySet;

public class InitialConditions
implements AddableTo {
    public ArrayList<ConcentrationSet> concentrationSets;
    public HashMap<String, ConcentrationSet> concSetHM;
    public ArrayList<SurfaceDensitySet> sdSets;
    public HashMap<String, SurfaceDensitySet> sdSetHM;
    public FitConstraints fitConstraints;
    ConcentrationSet defaultConcs;

    @Override
    public void add(Object obj) {
        if (this.concentrationSets == null) {
            this.concentrationSets = new ArrayList();
            this.concSetHM = new HashMap();
        }
        if (this.sdSets == null) {
            this.sdSets = new ArrayList();
            this.sdSetHM = new HashMap();
        }
        if (obj instanceof ConcentrationSet) {
            ConcentrationSet cset = (ConcentrationSet)obj;
            this.concentrationSets.add(cset);
            if (cset.hasRegion()) {
                this.concSetHM.put(cset.getRegion(), cset);
            }
            if (this.defaultConcs == null) {
                this.defaultConcs = cset;
            } else if (this.defaultConcs.hasRegion() && !cset.hasRegion()) {
                this.defaultConcs = cset;
            }
        } else if (obj instanceof SurfaceDensitySet) {
            SurfaceDensitySet sdset = (SurfaceDensitySet)obj;
            this.sdSets.add(sdset);
            if (sdset.hasRegion()) {
                this.sdSetHM.put(sdset.getRegion(), sdset);
            }
        } else if (obj instanceof FitConstraints) {
            this.fitConstraints = (FitConstraints)obj;
        } else {
            E.error("cant add " + obj);
        }
    }

    public ArrayList<FloatValued> getFloatValuedElements() {
        ArrayList<FloatValued> afv = new ArrayList<FloatValued>();
        if (this.concentrationSets != null) {
            for (ConcentrationSet cs : this.concentrationSets) {
                cs.addFloatValued(afv);
            }
        }
        if (this.sdSets != null) {
            for (SurfaceDensitySet sdSet : this.sdSets) {
                sdSet.addFloatValued(afv);
            }
        }
        return afv;
    }

    public double[] getDefaultNanoMolarConcentrations(String[] spl) {
        double[] ret = null;
        ret = this.defaultConcs != null ? this.defaultConcs.getNanoMolarConcentrations(spl) : new double[spl.length];
        int i = 0;
        while (i < ret.length) {
            if (ret[i] < 0.0) {
                ret[i] = 0.0;
            }
            ++i;
        }
        return ret;
    }

    public boolean hasConcentrationsFor(String rnm) {
        return rnm.equals("default") || this.concSetHM.containsKey(rnm);
    }

    public double[] getRegionConcentrations(String rnm, String[] spl) {
        double[] ret = null;
        if (this.concSetHM.containsKey(rnm)) {
            ret = this.concSetHM.get(rnm).getNanoMolarConcentrations(spl);
        } else if (rnm.equals("default")) {
            ret = this.defaultConcs.getNanoMolarConcentrations(spl);
        } else {
            E.error("want concentrations for unknown region " + rnm);
        }
        return ret;
    }

    public boolean hasSurfaceDensitiesFor(String rnm) {
        return this.sdSetHM.containsKey(rnm);
    }

    public double[] getRegionSurfaceDensities(String rnm, String[] spl) {
        double[] ret = null;
        if (this.sdSetHM.containsKey(rnm)) {
            ret = this.sdSetHM.get(rnm).getPicoSurfaceDensities(spl);
        } else {
            E.error("want concentrations for unknown region " + rnm);
        }
        return ret;
    }

    public String xmlSerialize() {
        StringBuffer sb = new StringBuffer();
        sb.append("<InitialConditions>\n");
        for (ConcentrationSet cset : this.concentrationSets) {
            sb.append("<ConcentrationSet");
            if (cset.hasRegion()) {
                sb.append("region=\"" + cset.getRegion() + "\">\n");
            } else {
                sb.append(">\n");
            }
            for (Concentration c : cset.concentrations) {
                sb.append("   " + c.makeXMLLine() + "\n");
            }
            sb.append("</ConcentrationSet>\n");
        }
        for (SurfaceDensitySet sdset : this.sdSets) {
            sb.append("<SurfaceDensitySet");
            if (sdset.hasRegion()) {
                sb.append("region=\"" + sdset.getRegion() + "\">\n");
            } else {
                sb.append(">\n");
            }
            for (SurfaceDensity sd : sdset.sds) {
                sb.append("   " + sd.makeXMLLine() + "\n");
            }
            sb.append("</SurfaceDensitySet>\n");
        }
        sb.append("</InitialConditions>\n");
        return sb.toString();
    }

    public String[] getTotalPreserved() {
        String[] ret = new String[]{};
        if (this.fitConstraints != null) {
            ret = this.fitConstraints.getTotalPreserved();
        }
        return ret;
    }
}

