/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.act;

import org.catacomb.act.BlockSignature;
import org.catacomb.report.E;

public class FunctionSignature
implements BlockSignature {
    public int type;
    public int sourceType;
    public String info;
    public String functionName;
    public Object[] argTypes;

    public FunctionSignature(String fn) {
        this(fn, 7);
    }

    public FunctionSignature(String fn, int typ) {
        this.functionName = fn;
        this.type = typ;
        this.sourceType = 1;
    }

    public void setUserSource() {
        this.sourceType = 1;
    }

    public void setSystemSource() {
        this.sourceType = 2;
    }

    @Override
    public int getTypeCode() {
        return this.type;
    }

    public static String getTypeInfo(int itc) {
        String ret = "";
        if (itc == 1) {
            ret = "Handlers: functions that are called when an event occurs in a connected component.";
        } else if (itc == 4) {
            ret = "Senders: these send an event to any connected components. The handler \non the receiving component will be called.";
        } else if (itc == 5) {
            ret = "Setters: these set a value for use later, but have no other effect: \nthe value is available to connected components if they ask for it";
        } else if (itc == 6) {
            ret = "Getters: give access to quantities in connected components.";
        }
        return ret;
    }

    public void setInfo(String s) {
        this.info = s;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    public String toJavaScriptStub() {
        String ret = null;
        ret = this.sourceType == 2 ? this.writeJsDoc() : this.writeEmptyJsFunction();
        return ret;
    }

    private String writeJsDoc() {
        StringBuffer sb = new StringBuffer();
        if (this.info != null) {
            if (this.info.indexOf("\n") > 0) {
                sb.append("/* Pre-defined function \n " + this.info + "\n*/\n");
            } else {
                sb.append("// Pre-defined function: " + this.info + "\n");
            }
        } else {
            sb.append("// Pre-defined  \n");
        }
        sb.append("//  ");
        sb.append(this.functionName);
        sb.append("(");
        if (this.argTypes != null) {
            E.missing();
        }
        sb.append(");\n");
        return sb.toString();
    }

    private String writeEmptyJsFunction() {
        StringBuffer sb = new StringBuffer();
        if (this.info != null) {
            if (this.info.length() > 60 || this.info.indexOf("\n") > 0) {
                sb.append("/*\n");
                sb.append(this.info);
                sb.append("\n");
            } else {
                sb.append("//");
                sb.append(this.info);
                sb.append("\n");
            }
        }
        sb.append("function ");
        sb.append(this.functionName);
        sb.append("(");
        if (this.argTypes != null) {
            E.missing();
        }
        sb.append(") {\n");
        sb.append("}\n");
        return sb.toString();
    }
}

