/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.formats;

import java.io.File;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.display.ViewConfig;
import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.dataview.formats.MeshDataReader;
import org.catacomb.dataview.formats.TableDataHandler;
import org.catacomb.dataview.formats.TableDataReader;
import org.catacomb.graph.gui.Geom;
import org.catacomb.graph.gui.Painter;
import org.catacomb.report.E;
import org.catacomb.util.ArrayUtil;

public class Mesh2plusTimeDisplay
implements DataHandler {
    double zval = 0.0;
    double zrange = 0.1;
    String[] plotNames;
    double[] frameValues;
    double[][][] mesh;
    double[][][] data;
    boolean[] mask;
    double[][][] innerMesh;
    int varIdx;
    int frameIdx;
    private Box meshBox;
    String plot;
    String viewStyle = "density";
    TableDataHandler coHandler = new TableDataHandler();
    double zMask = -999.0;

    @Override
    public void setZValue(double d) {
        this.zval = d;
    }

    @Override
    public String getMagic() {
        return "cctdif2d";
    }

    @Override
    public void read(File f) {
        TableDataReader tdr = new TableDataReader(this.coHandler);
        MeshDataReader mdr = new MeshDataReader(f, tdr);
        mdr.read();
        tdr.fix();
        this.mesh = mdr.getMesh();
        this.mask = new boolean[this.mesh.length];
        int i = 0;
        while (i < this.mask.length) {
            this.mask[i] = true;
            ++i;
        }
        this.data = mdr.getData();
        this.frameValues = mdr.getFrameValues();
        String[] vn = mdr.getValueNames();
        this.plotNames = new String[1 + vn.length];
        this.plotNames[0] = "mesh";
        int i2 = 0;
        while (i2 < vn.length) {
            this.plotNames[1 + i2] = vn[i2];
            ++i2;
        }
    }

    public void makeMeshMask() {
        int nel = this.mesh.length;
        double[] d = new double[nel];
        double md = 1000000.0;
        double xcen = 0.0;
        int i = 0;
        while (i < nel) {
            double x;
            d[i] = x = this.mesh[i][2][0] - this.zval;
            if (Math.abs(x) < md) {
                md = Math.abs(x);
                xcen = x;
            }
            ++i;
        }
        this.mask = new boolean[nel];
        if (md > this.zrange) {
            i = 0;
            while (i < nel) {
                this.mask[i] = false;
                ++i;
            }
        } else {
            i = 0;
            while (i < nel) {
                this.mask[i] = Math.abs(d[i] - xcen) < 0.5 * this.zrange;
                ++i;
            }
        }
        this.zMask = this.zval;
    }

    @Override
    public String[] getPlotNames() {
        return this.plotNames;
    }

    @Override
    public void setPlot(String s) {
        this.varIdx = this.varidx(s);
    }

    private int varidx(String s) {
        int dv = -1;
        int i = 0;
        while (i < this.plotNames.length) {
            if (this.plotNames[i].equals(s)) {
                dv = i - 1;
                break;
            }
            ++i;
        }
        return dv;
    }

    public double[] getFrameData(String s, int fidx) {
        int vi = this.varidx(s);
        double[] ret = this.data[fidx][vi];
        return ret;
    }

    public void setDisplayVariable(int i) {
        this.varIdx = i;
    }

    @Override
    public double getMinValue() {
        int vi = this.varIdx;
        if (vi < 0) {
            vi = 0;
        }
        return ArrayUtil.minD(this.data[this.frameIdx][vi]);
    }

    @Override
    public double getMaxValue() {
        int vi = this.varIdx;
        if (vi < 0) {
            vi = 0;
        }
        return ArrayUtil.maxD(this.data[this.frameIdx][vi]);
    }

    @Override
    public boolean antialias() {
        return false;
    }

    private void makeInnerMesh() {
        this.innerMesh = new double[this.mesh.length][2][];
        int i = 0;
        while (i < this.mesh.length) {
            double[][] di = Geom.innerPolygon(this.mesh[i][0], this.mesh[i][1]);
            this.innerMesh[i][0] = di[0];
            this.innerMesh[i][1] = di[1];
            ++i;
        }
    }

    @Override
    public void instruct(Painter p) {
        if (this.varIdx < 0) {
            this.instructMesh(p);
        } else {
            this.instructAreas(p);
        }
    }

    public void instructMesh(Painter p) {
        if (Math.abs(this.zMask - this.zval) > 0.1 * this.zrange) {
            this.makeMeshMask();
        }
        int nel = this.mesh.length;
        p.setColorWhite();
        int i = 0;
        while (i < nel) {
            if (this.mask[i]) {
                double[] xb = this.mesh[i][0];
                double[] yb = this.mesh[i][1];
                p.drawPolygon(xb, yb, xb.length);
            }
            ++i;
        }
        if (this.innerMesh == null) {
            this.makeInnerMesh();
        }
        p.setColorCyan();
    }

    public void instructAreas(Painter p) {
        if (Math.abs(this.zMask - this.zval) > 0.01) {
            this.makeMeshMask();
        }
        if (this.viewStyle.equals("density")) {
            this.instructDensity(p);
        } else {
            E.info("missing code - drawing density");
            this.instructDensity(p);
        }
    }

    public void instructDensity(Painter p) {
        if (this.frameIdx >= 0 && this.frameIdx < this.data.length && this.varIdx >= 0 && this.varIdx < this.data[this.frameIdx].length) {
            double[] dat = this.data[this.frameIdx][this.varIdx];
            p.drawColoredCells(this.mesh, dat, this.mask);
        }
    }

    @Override
    public Box getLimitBox() {
        if (this.meshBox == null && this.mesh != null) {
            this.meshBox = new Box();
            int i = 0;
            while (i < this.mesh.length) {
                this.meshBox.push(this.mesh[i][0], this.mesh[i][1]);
                ++i;
            }
        }
        return this.meshBox;
    }

    @Override
    public double[] getFrameValues() {
        return this.frameValues;
    }

    @Override
    public int getContentStyle() {
        return 2;
    }

    @Override
    public void setFrame(int ifr) {
        this.frameIdx = ifr;
    }

    @Override
    public String[] getViewOptions() {
        String[] ret = new String[]{"density", "particles"};
        return ret;
    }

    @Override
    public void setViewStyle(String s) {
        this.viewStyle = s;
    }

    @Override
    public DataHandler getCoHandler() {
        return this.coHandler;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public String getXAxisLabel() {
        return null;
    }

    @Override
    public String getYAxisLabel() {
        return null;
    }

    @Override
    public ViewConfig getViewConfig(String s) {
        return null;
    }
}

