/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.gui;

import java.io.File;
import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.dataview.formats.DataHandlerFactory;
import org.catacomb.dataview.formats.MeshSummary;
import org.catacomb.dataview.gui.BasicPlotController;
import org.catacomb.dataview.gui.Mesh2plusTimeController;
import org.catacomb.druid.dialog.Dialoguer;
import org.catacomb.druid.gui.edit.DruMenu;
import org.catacomb.interlish.annotation.ControlPoint;
import org.catacomb.interlish.annotation.IOPoint;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.report.E;
import org.catacomb.util.FileUtil;

public class CCVizController
implements Controller {
    @IOPoint(xid="ViewMenu")
    public DruMenu viewMenu;
    @ControlPoint(xid="basicController")
    public BasicPlotController basicController;
    @ControlPoint(xid="mesh2Controller")
    public Mesh2plusTimeController mesh2Controller;
    private DataHandler dataHandler;

    public void open() {
        File f = Dialoguer.getFile("CCViz");
        if (f != null) {
            this.open(f);
        }
    }

    public void open(File f) {
        String s = FileUtil.readFirstLine(f);
        this.dataHandler = DataHandlerFactory.getHandler(s);
        if (this.dataHandler == null) {
            int[] xy = new int[]{500, 500};
            Dialoguer.message(xy, "unrecognized file - cant plot " + s);
        } else {
            this.dataHandler.read(f);
            this.syncOptions();
            int ic = this.dataHandler.getContentStyle();
            if (ic == 1) {
                this.basicController.setDataHandler(this.dataHandler);
            } else if (ic == 2) {
                this.mesh2Controller.setDataHandler(this.dataHandler);
                DataHandler dh = this.dataHandler.getCoHandler();
                if (dh != null && dh.getContentStyle() == 1 && dh.hasData()) {
                    this.basicController.setDataHandler(dh);
                } else {
                    this.basicController.setDataHandler(new MeshSummary(this.dataHandler));
                }
            } else {
                E.missing();
            }
        }
    }

    public void requestClose() {
        this.exit();
    }

    public void reload() {
        E.info("time to reload...");
    }

    public void requestExit() {
        this.exit();
    }

    public void exit() {
        System.exit(0);
    }

    public void syncOptions() {
        String[] sa = new String[]{};
        if (this.dataHandler != null) {
            sa = this.dataHandler.getViewOptions();
        }
        this.viewMenu.setOptions(sa);
    }

    public void setViewStyle(String s) {
        if (this.dataHandler != null) {
            this.dataHandler.setViewStyle(s);
        }
        this.basicController.repaint();
        this.mesh2Controller.repaint();
    }

    @Override
    public void attached() {
    }
}

