/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.dialog;

import org.catacomb.druid.build.Druid;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.FrameShowable;

public abstract class DialogController
implements Controller {
    private Druid druid;

    public void checkInit() {
        if (this.druid == null) {
            this.druid = new Druid(this.getDialogDeclaration());
            this.druid.buildGUI();
            this.druid.attachSingleController(this);
        }
    }

    public String getDialogDeclaration() {
        String scn = this.getClass().getName();
        if (scn.endsWith("Controller")) {
            scn = scn.substring(0, scn.indexOf("Controller"));
        }
        return scn;
    }

    @Override
    public void attached() {
    }

    private boolean isShowing() {
        return this.druid.isShowing();
    }

    public void show(Object obj) {
    }

    public void hideDialog() {
        this.checkInit();
        this.druid.hide();
    }

    public void showModalAt(int x, int y) {
        this.checkInit();
        this.druid.setModal(true);
        if (this.isShowing()) {
            this.show();
        } else {
            this.showAt(x, y);
        }
    }

    public void showNonModalAt(int x, int y) {
        this.checkInit();
        this.druid.setModal(false);
        if (this.isShowing()) {
            this.show();
        } else {
            this.showAt(x, y);
        }
    }

    protected void show() {
        FrameShowable fs = this.druid.getFrameShowable();
        fs.pack();
        fs.show();
        fs.toFront();
    }

    protected void showAt(int x, int y) {
        this.checkInit();
        FrameShowable fs = this.druid.getFrameShowable();
        fs.pack();
        fs.setLocation(x, y);
        fs.show();
        fs.toFront();
    }
}

