/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.util.ArrayList;
import org.catacomb.druid.gui.base.DummyTree;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.gui.edit.DruMenu;
import org.catacomb.druid.swing.DCheckboxTree;
import org.catacomb.druid.swing.DScrollPane;
import org.catacomb.interlish.structure.Consumer;
import org.catacomb.interlish.structure.SelectionActor;
import org.catacomb.interlish.structure.Tree;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.interlish.structure.Visible;
import org.catacomb.report.E;

public class DruCheckboxTreePanel
extends DruGCPanel
implements SelectionActor,
Consumer,
Visible {
    static final long serialVersionUID = 1001L;
    DCheckboxTree dTree = new DCheckboxTree();
    DScrollPane scrollPane = new DScrollPane(this.dTree);
    Tree tree;
    String selectionType;

    public DruCheckboxTreePanel() {
        this.setBorderLayout(2, 2);
        this.addDComponent(this.scrollPane, "Center");
        this.scrollPane.setScrollSize(180, 240);
        this.setTree(new DummyTree());
    }

    public void clear() {
        this.tree = null;
        this.dTree.clear();
    }

    public void setTree(Tree tr) {
        if (tr != null) {
            this.tree = tr;
            this.dTree.setTree(this.tree);
            this.dTree.setSelectionActor(this);
            int ipol = this.tree.getRootPolicy();
            if (ipol == 2) {
                this.dTree.setRootVisible(false);
            } else if (ipol == 1) {
                this.dTree.setRootVisible(true);
            } else {
                this.dTree.setRootVisible(true);
            }
        }
    }

    @Override
    public void selectionAction(Object osel, String sid) {
        if (osel == null) {
            return;
        }
        if (osel instanceof TreeNode) {
            this.selectionType = ((TreeNode)osel).isLeaf() ? "leaf" : "branch";
        } else {
            E.warning("non tree node in tree selection " + osel);
            this.selectionType = "none";
        }
    }

    public void showNewItem(Object[] pathToChild) {
        this.dTree.setTree(this.tree);
        this.dTree.dTreeExpandPath(pathToChild);
    }

    public void setMenu(DruMenu drum) {
        this.dTree.setMenu(drum.getGUIPeer());
    }

    public String getSelectionType() {
        return this.selectionType;
    }

    private Object[] pathTo(TreeNode tn) {
        ArrayList<Object> al = new ArrayList<Object>();
        al.add(tn);
        Object obj = tn.getParent();
        while (obj != null) {
            al.add(0, obj);
            obj = obj instanceof TreeNode ? ((TreeNode)obj).getParent() : null;
        }
        return al.toArray();
    }

    public String[] getMultiStringSelection() {
        return this.dTree.getMultiStringSelection();
    }

    public String[] getExpandedMultiStringSelection() {
        return this.dTree.getExpandedMultiStringSelection();
    }

    public void setSelected(String[] content) {
        this.dTree.setSelected(content);
    }

    public void ensureVisible(TreeNode tn) {
        if (tn != null) {
            this.dTree.ensureVisible(this.pathTo(tn));
        }
    }
}

