/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.catacomb.druid.gui.base.DummyTree;
import org.catacomb.druid.swing.CheckTreeRenderer;
import org.catacomb.druid.swing.CheckTreeSelectionModel;
import org.catacomb.druid.swing.DMenu;
import org.catacomb.druid.swing.DTreeModel;
import org.catacomb.druid.swing.EmptyTree;
import org.catacomb.druid.swing.TCRenderer;
import org.catacomb.druid.swing.ToggleItem;
import org.catacomb.druid.swing.ui.DruidTreeUI;
import org.catacomb.interlish.structure.SelectionActor;
import org.catacomb.interlish.structure.Tree;
import org.catacomb.report.E;

public class DCheckboxTree
extends JTree
implements TreeSelectionListener,
MouseListener {
    static final long serialVersionUID = 1001L;
    public SelectionActor selectionActor;
    DTreeModel dTreeModel;
    DMenu dMenu;
    boolean p_doneMouseListener;
    ToggleItem[] toggleItems;
    HashMap<String, ToggleItem> tiHM;
    private CheckTreeSelectionModel selectionModel;
    int hotspot;

    public DCheckboxTree() {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.p_doneMouseListener = false;
        this.setForeground(Color.black);
        this.setUI(new DruidTreeUI());
        this.tiHM = new HashMap();
        this.getSelectionModel().setSelectionMode(1);
        TCRenderer renderer = new TCRenderer();
        this.setCellRenderer(renderer);
        this.addTreeSelectionListener(this);
        this.setTree(new DummyTree());
    }

    public void setSelectionActor(SelectionActor sa) {
        this.selectionActor = sa;
    }

    public void setTree(Tree tree) {
        this.dTreeModel = new DTreeModel(tree);
        this.setModel(this.dTreeModel);
        this.selectionModel = new CheckTreeSelectionModel(this.dTreeModel);
        this.setCellRenderer(new CheckTreeRenderer(new TCRenderer(), this.selectionModel));
        this.addMouseListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        TreePath path = this.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        if (me.getX() > this.getPathBounds((TreePath)path).x + this.hotspot) {
            return;
        }
        boolean selected = this.selectionModel.isPathSelected(path, true);
        this.selectionModel.removeTreeSelectionListener(this);
        try {
            if (selected) {
                this.selectionModel.removeSelectionPath(path);
            } else {
                this.selectionModel.addSelectionPath(path);
            }
        }
        finally {
            this.selectionModel.addTreeSelectionListener(this);
            this.treeDidChange();
        }
    }

    @Override
    public CheckTreeSelectionModel getSelectionModel() {
        if (this.selectionModel == null) {
            this.selectionModel = new CheckTreeSelectionModel(new DTreeModel(new EmptyTree()));
        }
        return this.selectionModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.treeDidChange();
    }

    public void clear() {
        this.setModel(new DTreeModel(new EmptyTree()));
    }

    public void dTreeExpandPath(Object[] oa) {
        TreePath tp = new TreePath(oa);
        this.expandPath(tp);
    }

    public void ensureVisible(Object[] oa) {
        if (oa.length > 1) {
            Object[] oas = new Object[oa.length - 1];
            int i = 0;
            while (i < oa.length - 1) {
                oas[i] = oa[i];
                ++i;
            }
            this.dTreeExpandPath(oas);
        }
        this.dTreeExpandPath(oa);
    }

    public void setMenu(DMenu dm) {
        if (!this.p_doneMouseListener) {
            this.addMouseListener(this);
            this.p_doneMouseListener = true;
        }
        this.dMenu = dm;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int modif = e.getModifiers();
        if (this.dMenu != null) {
            this.dMenu.preShowSync();
            if ((modif & 4) != 0) {
                this.dMenu.getPopupMenu().show(this, e.getX(), e.getY());
            }
        }
    }

    public void setBg(Color c) {
        this.setBackground(c);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private String makeSlashPath(TreePath tp) {
        Object[] oa = tp.getPath();
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < oa.length - 1) {
            sb.append(oa[i].toString());
            sb.append("/");
            ++i;
        }
        sb.append(oa[oa.length - 1].toString());
        return sb.toString();
    }

    public String[] getMultiStringSelection() {
        TreePath[] tpa = this.selectionModel.getSelectionPaths();
        String[] ret = new String[tpa.length];
        int i = 0;
        while (i < tpa.length) {
            ret[i] = this.makeSlashPath(tpa[i]);
            ++i;
        }
        return ret;
    }

    public String[] getExpandedMultiStringSelection() {
        ArrayList<String> asa = new ArrayList<String>();
        TreePath[] treePathArray = this.selectionModel.getSelectionPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath tp = treePathArray[n2];
            for (TreePath stp : this.selectionModel.getDescendantPaths(tp)) {
                asa.add(this.makeSlashPath(stp));
            }
            ++n2;
        }
        return asa.toArray(new String[0]);
    }

    public void addStringSelection(String sp) {
        Tree tr = this.dTreeModel.getTree();
        Object[] oa = tr.getObjectPath(sp, true);
        if (oa == null) {
            E.warning("cant get path for " + sp);
        } else {
            TreePath tp = new TreePath(oa);
            TreePath[] tpa = new TreePath[]{tp};
            this.selectionModel.addSelectionPaths(tpa);
        }
    }

    public void setSelected(String[] content) {
        this.selectionModel.clearSelection();
        if (content != null) {
            String[] stringArray = content;
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                String sp = stringArray[n2];
                if ((sp = sp.trim()).length() > 0) {
                    this.addStringSelection(sp);
                }
                ++n2;
            }
        }
    }
}

