/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.event.TextActor;
import org.catacomb.druid.swing.DPanel;
import org.catacomb.druid.swing.DScrollPane;
import org.catacomb.report.E;
import org.catacomb.util.StringUtil;

public class DTextArea
extends DPanel
implements DocumentListener,
FocusListener {
    static final long serialVersionUID = 1001L;
    public static final int BARE = 1;
    public static final int SCROLLABLE = 2;
    JTextArea jta;
    Font keepFont;
    TextActor textActor;
    DScrollPane jsp;
    LabelActor lableActor;
    boolean ignoreChanges = false;
    boolean changedWhileFocused;

    public DTextArea(String content) {
        this(20, 5, 1);
        this.setText(content);
    }

    public DTextArea(int ia, int ib) {
        this(ia, ib, 1);
    }

    public DTextArea(int ia, int ib, String content) {
        this(ia, ib, 1);
        this.setText(content);
    }

    public DTextArea(int width, int height, int type) {
        int nrow = height;
        int ncol = width;
        if (nrow < 2) {
            nrow = 2;
        }
        if (ncol < 10) {
            ncol = 10;
        }
        this.setLayout(new BorderLayout());
        this.jta = new JTextArea(nrow, ncol);
        this.jta.setLineWrap(true);
        if (this.keepFont != null) {
            this.jta.setFont(this.keepFont);
        }
        if (type == 2) {
            this.jsp = new DScrollPane(this.jta);
            this.jsp.setNoBorder();
            this.add("Center", this.jsp);
        } else {
            this.add("Center", this.jta);
        }
        this.jta.getDocument().addDocumentListener(this);
        this.jta.addFocusListener(this);
    }

    public void setLineBorder(int icol) {
        this.setBorder(BorderFactory.createLineBorder(new Color(icol)));
    }

    public void addLine() {
        int nr = this.jta.getRows();
        this.jta.setRows(nr + 1);
    }

    public void removeLine() {
        int nr = this.jta.getRows();
        if (nr > 1) {
            this.jta.setRows(nr - 1);
        }
    }

    @Override
    public void setBg(Color c) {
        this.jta.setBackground(c);
        this.jsp.setBackground(c);
        this.setBackground(c);
    }

    public void setLabelActor(LabelActor lact) {
        System.out.println("NB label actor in text are is unused");
        new Exception().printStackTrace();
    }

    @Override
    public void setEnabled(boolean b) {
        this.jta.setEnabled(b);
        this.jta.setEditable(b);
    }

    @Override
    public void setFont(Font f) {
        if (this.jta != null) {
            this.jta.setFont(f);
        } else {
            this.keepFont = f;
        }
    }

    public void setBackgroundColor(Color c) {
        this.jta.setBackground(c);
        this.setBackground(c);
    }

    public void setTextActor(TextActor ed) {
        this.textActor = ed;
    }

    public void setColumns(int nc) {
        this.jta.setColumns(nc);
    }

    public void setRows(int nc) {
        this.jta.setRows(nc);
    }

    @Override
    public void changedUpdate(DocumentEvent d) {
        this.flagChange();
    }

    @Override
    public void insertUpdate(DocumentEvent d) {
        this.flagChange();
    }

    @Override
    public void removeUpdate(DocumentEvent d) {
        this.flagChange();
    }

    private void flagChange() {
        if (!this.ignoreChanges) {
            this.changedWhileFocused = true;
            if (this.textActor != null) {
                this.textActor.textChanged(null);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent fev) {
        this.changedWhileFocused = false;
    }

    @Override
    public void focusLost(FocusEvent fev) {
        if (this.changedWhileFocused && this.textActor != null) {
            this.textActor.textEdited(this.getText());
        }
    }

    public String getText() {
        return this.jta.getText();
    }

    public void setText(String s) {
        this.ignoreChanges = true;
        this.jta.setText(s);
        this.ignoreChanges = false;
    }

    public void setEditable(boolean b) {
        this.jta.setEditable(b);
    }

    public void highlightLine(int highlight) {
        try {
            int c0 = this.jta.getLineStartOffset(highlight);
            int c1 = this.jta.getLineEndOffset(highlight);
            this.jta.setSelectionColor(new Color(255, 102, 51));
            this.jta.setSelectionStart(c0);
            this.jta.setSelectionEnd(c1);
            this.jta.requestFocusInWindow();
        }
        catch (Exception ex) {
            E.warning("Exception highlighting text? " + ex + " want line " + highlight + " from text " + this.jta.getText());
        }
    }

    public void clearHighlight() {
    }

    public void setAntialiased() {
        E.missing("setting aa in DTextArea");
    }

    public void setPadding(int padding) {
    }

    public void setFontSize(int fs) {
        this.setFont(new Font(null, 0, fs));
    }

    public void resizeUpToText() {
        String stxt = this.getText().trim();
        int nlines = StringUtil.countLines(stxt);
        if (nlines >= this.jta.getRows()) {
            this.jta.setRows(nlines + 1);
            this.revalidate();
        }
    }
}

