/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.dnd;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import org.catacomb.druid.swing.DTextCanvas;
import org.catacomb.druid.swing.ImageDragSource;
import org.catacomb.druid.swing.dnd.DragAndDrop;
import org.catacomb.druid.swing.dnd.Region;
import org.catacomb.druid.swing.dnd.RegionBoard;
import org.catacomb.report.E;

public class RegionDropTarget
implements DropTargetListener {
    DropTarget target;
    RegionBoard regionBoard;
    DTextCanvas textCanvas;
    Rectangle dragBounds;
    Region previousDragRegion;

    public RegionDropTarget(RegionBoard rb) {
        this.regionBoard = rb;
        this.textCanvas = rb.getCanvas();
        this.target = new DropTarget(this.textCanvas, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.dragBounds != null) {
            this.textCanvas.paintImmediately(this.dragBounds);
        } else {
            this.dragBounds = new Rectangle();
        }
        Point p = dtde.getLocation();
        DragAndDrop obj = DragAndDrop.getDnD();
        if (obj instanceof ImageDragSource) {
            ImageDragSource ids = obj;
            BufferedImage bim = ids.getDragImage();
            Point poff = ids.getDragImageOffset();
            int bw = bim.getWidth();
            int bh = bim.getHeight();
            if (bim == null) {
                // empty if block
            }
            this.dragBounds.setRect(p.x - poff.x, p.y - poff.y, bw, bh);
            Graphics g = this.textCanvas.getGraphics();
            this.dragAt(g, p.x - poff.x + bw / 2, p.y - poff.y + bh / 2);
            g.drawImage(bim, (int)this.dragBounds.getX(), (int)this.dragBounds.getY(), null);
        } else {
            E.warning("wrong type of source " + obj);
        }
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void dragAt(Graphics g, int i, int j) {
        this.clearDragEcho();
        Region reg = this.regionBoard.getDragOverRegion(i, j);
        if (reg != null) {
            if (reg.acceptsDrops()) {
                g.setColor(Color.green);
                g.drawRect(reg.getX(), reg.getY(), reg.getW(), reg.getH());
                g.drawRect(reg.getX() + 1, reg.getY() + 1, reg.getW() - 2, reg.getH() - 2);
            }
            this.previousDragRegion = reg;
        }
    }

    public void clearDragEcho() {
        if (this.previousDragRegion != null) {
            this.regionBoard.unecho(this.previousDragRegion);
            this.previousDragRegion = null;
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.dragBounds != null) {
            this.textCanvas.paintImmediately(this.dragBounds);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Region dropReg = this.regionBoard.getDragOverRegion();
        Object dropee = DragAndDrop.getDnD().getDragSource();
        if (dropReg == null) {
            this.regionBoard.dropGeneral(dropee);
        } else if (dropReg.acceptsDrops()) {
            this.regionBoard.dropOn(dropee, dropReg);
        }
    }
}

